/*
 * Decompiled with CFR 0.152.
 */
package com.kio7po.originsfurs.fabric.client.util;

import com.google.common.hash.Hashing;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.type.ModelColorPowerType;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_5253;
import net.minecraft.class_742;
import org.joml.Vector3d;

@Environment(value=EnvType.CLIENT)
public class Alib {
    public static long getHash64(String input) {
        return Hashing.murmur3_128().hashString((CharSequence)input, StandardCharsets.UTF_8).asLong();
    }

    public static Vector3d jsonToVector3d(JsonElement element) {
        JsonElement jsonElement = element;
        Objects.requireNonNull(jsonElement);
        JsonElement jsonElement2 = jsonElement;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonArray.class, JsonObject.class, JsonPrimitive.class}, (Object)jsonElement2, n)) {
                case 0: {
                    JsonArray array = (JsonArray)jsonElement2;
                    if (array.size() != 3) {
                        throw new JsonParseException("Expected 3 elements in array, got " + array.size());
                    }
                    return new Vector3d(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble());
                }
                case 1: {
                    JsonObject object = (JsonObject)jsonElement2;
                    if (!(object.has("x") && object.has("y") && object.has("z"))) {
                        throw new JsonParseException("Missing required field(s) in vector object");
                    }
                    return new Vector3d(object.get("x").getAsDouble(), object.get("y").getAsDouble(), object.get("z").getAsDouble());
                }
                case 2: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement2;
                    if (!primitive.isNumber()) {
                        n = 3;
                        continue block5;
                    }
                    return Alib.longToVector3d(primitive.getAsLong());
                }
            }
            break;
        }
        throw new JsonParseException("Failed to parse Vector3d from JSON: " + String.valueOf(element));
    }

    private static Vector3d longToVector3d(long value) {
        return new Vector3d((double)(value & 0xFFFFL), (double)(value >> 16 & 0xFFFFL), (double)(value >> 32 & 0xFFFFL));
    }

    public static int getArgbFromColorPowers(int argb, List<ModelColorPowerType> modelColorPowers) {
        float newRed = modelColorPowers.stream().map(ModelColorPowerType::getRed).reduce(Float.valueOf((float)class_5253.class_5254.method_27765((int)argb) / 255.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
        float newGreen = modelColorPowers.stream().map(ModelColorPowerType::getGreen).reduce(Float.valueOf((float)class_5253.class_5254.method_27766((int)argb) / 255.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
        float newBlue = modelColorPowers.stream().map(ModelColorPowerType::getBlue).reduce(Float.valueOf((float)class_5253.class_5254.method_27767((int)argb) / 255.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
        float oldAlpha = (float)class_5253.class_5254.method_27762((int)argb) / 255.0f;
        float newAlpha = modelColorPowers.stream().map(ModelColorPowerType::getAlpha).min(Float::compareTo).map(alphaFactor -> Float.valueOf(oldAlpha * alphaFactor.floatValue())).orElse(Float.valueOf(oldAlpha)).floatValue();
        return class_5253.class_5254.method_59554((float)newAlpha, (float)newRed, (float)newGreen, (float)newBlue);
    }

    public static class_1921 getRenderLayer(class_2960 texture, boolean visible, boolean revealed, boolean outlined, boolean emissive) {
        if (visible || revealed) {
            return emissive ? class_1921.method_42600((class_2960)texture) : class_1921.method_23580((class_2960)texture);
        }
        return outlined ? class_1921.method_23287((class_2960)texture) : null;
    }

    public static int getRenderColor(class_742 entity, boolean revealed) {
        int argb = class_5253.class_5254.method_59554((float)(revealed ? 0.15f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f);
        List modelColorPowers = PowerHolderComponent.getPowerTypes((class_1297)entity, ModelColorPowerType.class);
        if (!modelColorPowers.isEmpty()) {
            argb = Alib.getArgbFromColorPowers(argb, modelColorPowers);
        }
        return argb;
    }
}

