/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.ArrayList;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.spell_power.SpellPowerMod;
import net.spell_power.config.AttributesConfig;
import org.jetbrains.annotations.Nullable;

public class SpellResistance {
    public static double resist(class_1309 target, double damage, class_1282 source) {
        double modifier = 1.0;
        AttributesConfig config = (AttributesConfig)SpellPowerMod.attributesConfig.value;
        for (Attributes.Entry resistanceType : Attributes.all) {
            if (!target.method_6127().method_45331(resistanceType.attributeEntry) || !source.method_48789(resistanceType.damageTypes)) continue;
            float resistancePoints = (float)target.method_45325(resistanceType.attributeEntry);
            float reduction = 0.0f;
            switch (config.resistance_curve) {
                case LINEAR: {
                    reduction = resistancePoints / config.resistance_tuning_constant;
                    break;
                }
                case QUADRATIC: {
                    reduction = (float)Math.sqrt(resistancePoints * config.resistance_tuning_constant) * config.resistance_tuning_constant;
                    break;
                }
                case HYPERBOLIC: {
                    reduction = resistancePoints / (resistancePoints + config.resistance_tuning_constant);
                }
            }
            reduction = Math.min(reduction * config.resistance_multiplier, config.resistance_reduction_cap);
            modifier *= (double)(1.0f - reduction);
        }
        return damage * modifier;
    }

    public static class Attributes {
        public static final ArrayList<Entry> all = new ArrayList();
        public static final Entry GENERIC = Attributes.entry("generic", "resistable", 1024.0, true);

        public static Entry entry(String name, String tagName, double maxValue, boolean tracked) {
            return Attributes.entry("resistance." + name, class_2960.method_60655((String)"spell_power", (String)tagName), maxValue, tracked);
        }

        public static Entry entry(String name, class_2960 damageTagId, double maxValue, boolean tracked) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)damageTagId);
            Entry entry = new Entry(name, (class_6862<class_8110>)tag, maxValue, tracked);
            all.add(entry);
            return entry;
        }

        public static class Entry {
            public final class_2960 id;
            public final String translationKey;
            public final class_1320 attribute;
            public final double baseValue;
            public final class_6862<class_8110> damageTypes;
            public final double maxValue;
            @Nullable
            public class_6880<class_1320> attributeEntry;

            public Entry(String name, class_6862<class_8110> tag, double maxValue, boolean tracked) {
                this.id = class_2960.method_60655((String)"spell_power", (String)name);
                this.translationKey = "attribute.name.spell_power." + name;
                double baseValue = 0.0;
                double minValue = 0.0;
                this.attribute = new class_1329(this.translationKey, baseValue, minValue, maxValue).method_26829(tracked);
                this.baseValue = baseValue;
                this.maxValue = maxValue;
                this.damageTypes = tag;
            }

            public void registerAttribute() {
                this.attributeEntry = class_2378.method_47985((class_2378)class_7923.field_41190, (class_2960)this.id, (Object)this.attribute);
            }
        }
    }
}

