/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;

public class PaintingsLoader
extends class_4080<Map<class_2960, Map.Entry<Painting, class_3298>>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson GSON = new GsonBuilder().create();
    private static final String dataType = "paintings";
    private static final int dataTypeLength = "paintings".length() + 1;
    private static final int fileSuffixLength = ".json".length();
    protected static final class_2960 ID = Main.locate("paintings");

    protected Map<class_2960, Map.Entry<Painting, class_3298>> prepare(class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, Map.Entry<Painting, class_3298>> map = new HashMap<class_2960, Map.Entry<Painting, class_3298>>();
        Map resources = manager.method_14488(dataType, path -> path.method_12832().endsWith(".png"));
        for (Map.Entry entry : resources.entrySet()) {
            String string = ((class_2960)entry.getKey()).method_12832();
            class_2960 imageIdentifier = class_2960.method_60655((String)((class_2960)entry.getKey()).method_12836(), (String)string.substring(dataTypeLength, string.length() - fileSuffixLength));
            try {
                class_2960 jsonIdentifier = class_2960.method_60655((String)((class_2960)entry.getKey()).method_12836(), (String)string.replace(".png", ".json"));
                Optional resource = manager.method_14486(jsonIdentifier);
                if (resource.isEmpty()) {
                    LOGGER.error("Couldn't load painting {} from {}: no resource present", (Object)imageIdentifier, entry.getKey());
                    continue;
                }
                InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482(), StandardCharsets.UTF_8);
                JsonObject jsonElement = Objects.requireNonNull((JsonElement)class_3518.method_15276((Gson)this.GSON, (Reader)reader, JsonElement.class)).getAsJsonObject();
                int width = class_3518.method_15282((JsonObject)jsonElement, (String)"width", (int)1);
                int height = class_3518.method_15282((JsonObject)jsonElement, (String)"height", (int)1);
                int resolution = class_3518.method_15282((JsonObject)jsonElement, (String)"resolution", (int)32);
                String name = class_3518.method_15253((JsonObject)jsonElement, (String)"name", (String)"unknown");
                String author = class_3518.method_15253((JsonObject)jsonElement, (String)"author", (String)"unknown");
                boolean graffiti = class_3518.method_15258((JsonObject)jsonElement, (String)"graffiti", (boolean)false);
                String hash = ((class_2960)entry.getKey()).toString().replaceAll("[^a-zA-Z\\d]", "");
                EnumSet<Painting.Flag> flags = EnumSet.noneOf(Painting.Flag.class);
                if (graffiti) {
                    flags.add(Painting.Flag.GRAFFITI);
                }
                Painting painting = new Painting(width, height, resolution, name, author, UUID.randomUUID(), Painting.Type.DATAPACK, flags, hash);
                map.put(painting.location(), Map.entry(painting, (class_3298)entry.getValue()));
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't load painting {} from {} ({})", new Object[]{imageIdentifier, entry.getKey(), exception});
            }
        }
        return map;
    }

    protected void apply(Map<class_2960, Map.Entry<Painting, class_3298>> prepared, class_3300 manager, class_3695 profiler) {
        ServerPaintingManager.setDatapackPaintings(prepared);
    }
}

