/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3162;
import net.minecraft.class_3169;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.argument.ScaleEasingArgumentType;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.mixin.DataCommandInvoker;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class ScaleCommand {
    private static final Random RANDOM = new Random();
    private static final DecimalFormat SCALE_FORMAT = new DecimalFormat("#,##0");

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment() && !PehkuiConfig.COMMON.enableCommands.get().booleanValue()) {
            return;
        }
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"scale").requires(source -> source.method_9259(2));
        ScaleCommand.registerOperation((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerRandomize((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerGet((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerCompute((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerReset((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerModifier((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerDelay((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerEasing((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerPersist((LiteralArgumentBuilder<class_2168>)builder);
        ScaleCommand.registerNbt((LiteralArgumentBuilder<class_2168>)builder);
        commandDispatcher.register(builder);
    }

    private static LiteralArgumentBuilder<class_2168> registerOperation(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"operation", (ArgumentType)ScaleOperationArgumentType.operation()).then(class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "operation");
                data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            }
            return 1;
        }))).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "operation");
            data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            return 1;
        })))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "operation");
                data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            }
            return 1;
        }))).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"value");
            ScaleData data = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229());
            ScaleOperationArgumentType.Operation operation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "operation");
            data.setTargetScale((float)operation.apply(data.getTargetScale(), scale));
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerRandomize(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"randomize").then(class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"minOperation", (ArgumentType)ScaleOperationArgumentType.operation()).then(class_2170.method_9244((String)"minValue", (ArgumentType)FloatArgumentType.floatArg()).then(class_2170.method_9244((String)"maxOperation", (ArgumentType)ScaleOperationArgumentType.operation()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"maxValue", (ArgumentType)FloatArgumentType.floatArg()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            float minValue = FloatArgumentType.getFloat((CommandContext)context, (String)"minValue");
            float maxValue = FloatArgumentType.getFloat((CommandContext)context, (String)"maxValue");
            ScaleOperationArgumentType.Operation minOperation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "minOperation");
            ScaleOperationArgumentType.Operation maxOperation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "maxOperation");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                double target = data.getTargetScale();
                double min = minOperation.apply(target, minValue);
                double max = maxOperation.apply(target, maxValue);
                if (max < min) {
                    double temp = min;
                    min = max;
                    max = temp;
                }
                data.setTargetScale((float)(min + (double)RANDOM.nextFloat() * (max - min)));
            }
            return 1;
        }))).executes(context -> {
            float minValue = FloatArgumentType.getFloat((CommandContext)context, (String)"minValue");
            float maxValue = FloatArgumentType.getFloat((CommandContext)context, (String)"maxValue");
            ScaleOperationArgumentType.Operation minOperation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "minOperation");
            ScaleOperationArgumentType.Operation maxOperation = ScaleOperationArgumentType.getOperation((CommandContext<class_2168>)context, "maxOperation");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            double target = data.getTargetScale();
            double min = minOperation.apply(target, minValue);
            double max = maxOperation.apply(target, maxValue);
            if (max < min) {
                double temp = min;
                min = max;
                max = temp;
            }
            data.setTargetScale((float)(min + (double)RANDOM.nextFloat() * (max - min)));
            return 1;
        })))))));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerGet(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getBaseScale();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(class_2170.method_9244((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(((class_2168)context.getSource()).method_9229()).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(((class_2168)context.getSource()).method_9229()).getBaseScale();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(class_2170.method_9244((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229()).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getBaseScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getBaseScale();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).executes(context -> {
            float scale = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229()).getBaseScale();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerCompute(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"compute").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getScale();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        }))).then(class_2170.method_9244((String)"scalingFactor", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(((class_2168)context.getSource()).method_9229()).getScale();
            int scaled = (int)(scale * FloatArgumentType.getFloat((CommandContext)context, (String)"scalingFactor"));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale, scaled), false);
            return scaled;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            float scale = type.getScaleData(((class_2168)context.getSource()).method_9229()).getScale();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.scaleText(scale), false);
            return (int)scale;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerReset(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
                ScaleData data = type.getScaleData(e);
                Boolean persist = data.getPersistence();
                data.resetScale();
                data.setPersistence(persist);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            Boolean persist = data.getPersistence();
            data.resetScale();
            data.setPersistence(persist);
            return 1;
        }))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    Boolean persist = data.getPersistence();
                    data.resetScale();
                    data.setPersistence(persist);
                }
            }
            return 1;
        }))).executes(context -> {
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
                Boolean persist = data.getPersistence();
                data.resetScale();
                data.setPersistence(persist);
            }
            return 1;
        }));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerModifier(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modifier").then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity"));
            String modifierString = String.join((CharSequence)", ", data.getBaseValueModifiers().stream().map(e -> ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, e).toString()).collect(Collectors.toList()));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.modifierText(modifierString), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            String modifierString = String.join((CharSequence)", ", type.getDefaultBaseValueModifiers().stream().map(e -> ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, e).toString()).collect(Collectors.toList()));
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.modifierText(modifierString), false);
            return 1;
        })))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_modifier", (ArgumentType)ScaleModifierArgumentType.scaleModifier()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
                ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<class_2168>)context, "scale_modifier");
                ScaleData data = type.getScaleData(e);
                data.getBaseValueModifiers().add(modifier);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<class_2168>)context, "scale_modifier");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.getBaseValueModifiers().add(modifier);
            return 1;
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_modifier", (ArgumentType)ScaleModifierArgumentType.scaleModifier()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
                ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<class_2168>)context, "scale_modifier");
                ScaleData data = type.getScaleData(e);
                data.getBaseValueModifiers().remove(modifier);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleModifier modifier = ScaleModifierArgumentType.getScaleModifierArgument((CommandContext<class_2168>)context, "scale_modifier");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.getBaseValueModifiers().remove(modifier);
            return 1;
        }))))).then(class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
                ScaleData data = type.getScaleData(e);
                SortedSet<ScaleModifier> baseValueModifiers = data.getBaseValueModifiers();
                baseValueModifiers.clear();
                baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            SortedSet<ScaleModifier> baseValueModifiers = data.getBaseValueModifiers();
            baseValueModifiers.clear();
            baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
            return 1;
        }))));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerDelay(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delay").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            return 1;
        }))).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setScaleTickDelay(ticks);
            return 1;
        })))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            return 1;
        }))).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ScaleData data = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setScaleTickDelay(ticks);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            int ticks = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getScaleTickDelay();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            int ticks = type.getScaleData(((class_2168)context.getSource()).method_9229()).getScaleTickDelay();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            int ticks = ScaleTypes.BASE.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getScaleTickDelay();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            int ticks = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229()).getScaleTickDelay();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            int ticks = type.getDefaultTickDelay();
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            int ticks = type.getDefaultTickDelay();
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setScaleTickDelay(ticks);
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            int ticks = ScaleTypes.BASE.getDefaultTickDelay();
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                data.setScaleTickDelay(ticks);
            }
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        }))).executes(context -> {
            int ticks = ScaleTypes.BASE.getDefaultTickDelay();
            ScaleData data = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setScaleTickDelay(ticks);
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.delayText(ticks), false);
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerEasing(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"easing").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"easing", (ArgumentType)ScaleEasingArgumentType.scaleEasing()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            Float2FloatFunction easing = ScaleEasingArgumentType.getScaleEasingArgument((CommandContext<class_2168>)context, "easing");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setEasing(easing);
            }
            return 1;
        }))).executes(context -> {
            Float2FloatFunction easing = ScaleEasingArgumentType.getScaleEasingArgument((CommandContext<class_2168>)context, "easing");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setEasing(easing);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            Float2FloatFunction easing = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getEasing();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(easing, type), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            Float2FloatFunction easing = type.getScaleData(((class_2168)context.getSource()).method_9229()).getEasing();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(easing, type), false);
            return 1;
        }))).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            Float2FloatFunction easing = ScaleTypes.BASE.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getEasing();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(easing, ScaleTypes.BASE), false);
            return 1;
        }))).executes(context -> {
            Float2FloatFunction easing = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229()).getEasing();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(easing, ScaleTypes.BASE), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setEasing(null);
            }
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(null, type), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setEasing(null);
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(null, type), false);
            return 1;
        }))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = ScaleTypes.BASE.getScaleData(e);
                data.setEasing(null);
            }
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(null, ScaleTypes.BASE), false);
            return 1;
        }))).executes(context -> {
            ScaleData data = ScaleTypes.BASE.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setEasing(null);
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.easingText(null, ScaleTypes.BASE), false);
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerPersist(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"persist").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setPersistence(persist);
            }
            return 1;
        }))).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setPersistence(persist);
            return 1;
        })))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    data.setPersistence(persist);
                }
            }
            return 1;
        }))).executes(context -> {
            boolean persist = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
                data.setPersistence(persist);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            Boolean persist = type.getScaleData(class_2186.method_9313((CommandContext)context, (String)"entity")).getPersistence();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.persistenceText(persist, type), false);
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            Boolean persist = type.getScaleData(((class_2168)context.getSource()).method_9229()).getPersistence();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> ScaleCommand.persistenceText(persist, type), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale_type", (ArgumentType)ScaleTypeArgumentType.scaleType()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                ScaleData data = type.getScaleData(e);
                data.setPersistence(null);
            }
            return 1;
        }))).executes(context -> {
            ScaleType type = ScaleTypeArgumentType.getScaleTypeArgument((CommandContext<class_2168>)context, "scale_type");
            ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
            data.setPersistence(null);
            return 1;
        }))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> {
            for (class_1297 e : class_2186.method_9317((CommandContext)context, (String)"targets")) {
                for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                    ScaleData data = type.getScaleData(e);
                    data.setPersistence(null);
                }
            }
            return 1;
        }))).executes(context -> {
            for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
                ScaleData data = type.getScaleData(((class_2168)context.getSource()).method_9229());
                data.setPersistence(null);
            }
            return 1;
        })));
        return builder;
    }

    private static LiteralArgumentBuilder<class_2168> registerNbt(LiteralArgumentBuilder<class_2168> builder) {
        builder.then(class_2170.method_9247((String)"nbt").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)class_2203.method_9360()).executes(context -> DataCommandInvoker.Path.callMethod_13916((class_2168)context.getSource(), (class_3162)new EntityScaleDataObject(class_2186.method_9313((CommandContext)context, (String)"entity")), class_2203.method_9358((CommandContext)context, (String)"path")))).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> DataCommandInvoker.Scaled.callMethod_13903((class_2168)context.getSource(), (class_3162)new EntityScaleDataObject(class_2186.method_9313((CommandContext)context, (String)"entity")), class_2203.method_9358((CommandContext)context, (String)"path"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))).executes(context -> DataCommandInvoker.Get.callMethod_13908((class_2168)context.getSource(), (class_3162)new EntityScaleDataObject(class_2186.method_9313((CommandContext)context, (String)"entity")))))).executes(context -> {
            EntityScaleDataObject obj = new EntityScaleDataObject(((class_2168)context.getSource()).method_9229());
            class_2487 nbt = obj.method_13881();
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> obj.method_13882((class_2520)nbt), false);
            return nbt.method_10546();
        })));
        return builder;
    }

    private static class_2561 scaleText(float scale) {
        long denominator = (long)(1.0f / scale);
        if ((long)scale != 1L && Float.compare(scale, 1.0f / (float)denominator) == 0) {
            return I18nUtils.translate("commands.pehkui.scale.get.fraction.message", "Scale: %s (1/%s)", ScaleCommand.format(scale), ScaleCommand.format(denominator));
        }
        return I18nUtils.translate("commands.pehkui.scale.get.message", "Scale: %s", ScaleCommand.format(scale));
    }

    private static class_2561 scaleText(float scale, int multiplied) {
        long denominator = (long)(1.0f / scale);
        if ((long)scale != 1L && Float.compare(scale, 1.0f / (float)denominator) == 0) {
            return I18nUtils.translate("commands.pehkui.scale.get.fraction.factor.message", "Scale: %s (1/%s) | (%s)", ScaleCommand.format(scale), ScaleCommand.format(denominator), ScaleCommand.format(multiplied));
        }
        return I18nUtils.translate("commands.pehkui.scale.get.factor.message", "Scale: %s | (%s)", ScaleCommand.format(scale), ScaleCommand.format(multiplied));
    }

    private static class_2561 modifierText(String modifierString) {
        return I18nUtils.translate("commands.pehkui.scale.modifier.get.message", "%s", modifierString.isEmpty() ? "N/A" : modifierString);
    }

    private static class_2561 delayText(int ticks) {
        return I18nUtils.translate("commands.pehkui.scale.delay.get.message", "Delay: %s ticks", ScaleCommand.format(ticks));
    }

    private static class_2561 persistenceText(@Nullable Boolean persist, ScaleType type) {
        String unlocalized = "commands.pehkui.scale.persist." + (persist != null ? persist : "default." + type.getDefaultPersistence());
        String message = "Persistent: " + (persist == null ? "default (" + type.getDefaultPersistence() + ")" : persist);
        return I18nUtils.translate(unlocalized, message);
    }

    private static class_2561 easingText(@Nullable Float2FloatFunction easing, ScaleType type) {
        String easingId = ScaleRegistries.getId(ScaleRegistries.SCALE_EASINGS, easing != null ? easing : type.getDefaultEasing()).toString();
        String unlocalized = "commands.pehkui.scale.easing" + (easing != null ? "" : ".default");
        String message = "Easing: " + (easing == null ? "default (" + easingId + ")" : easingId);
        return I18nUtils.translate(unlocalized, message, easingId);
    }

    private static String format(int scale) {
        return SCALE_FORMAT.format(scale);
    }

    private static String format(long scale) {
        return SCALE_FORMAT.format(scale);
    }

    private static String format(float scale) {
        return SCALE_FORMAT.format(scale);
    }

    static {
        SCALE_FORMAT.setMaximumFractionDigits(340);
    }

    private static class EntityScaleDataObject
    extends class_3169 {
        private final class_1297 entity;

        public EntityScaleDataObject(class_1297 entity) {
            super(entity);
            this.entity = entity;
        }

        public void method_13880(class_2487 nbt) throws CommandSyntaxException {
            ((PehkuiEntityExtensions)this.entity).pehkui_readScaleNbt(nbt);
        }

        public class_2487 method_13881() {
            return ((PehkuiEntityExtensions)this.entity).pehkui_writeScaleNbt(new class_2487());
        }
    }
}

