/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.util.PrioritizedEntry;
import io.github.apace100.calio.CalioServer;
import io.github.apace100.calio.data.IdentifiableMultiJsonDataLoader;
import io.github.apace100.calio.data.MultiJsonDataContainer;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.integration.CarpetIntegration;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.networking.packet.s2c.OpenChooseOriginScreenS2CPacket;
import io.github.apace100.origins.networking.packet.s2c.SyncOriginLayersS2CPacket;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.registry.ModComponents;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class OriginLayerManager
extends IdentifiableMultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static final Set<class_2960> DEPENDENCIES = (Set)class_156.method_654((Object)new ObjectOpenHashSet(), set -> set.add((Object)OriginManager.ID));
    public static final class_2960 ID = Origins.identifier("origin_layers");
    private static final Object2ObjectOpenHashMap<class_2960, OriginLayer> LAYERS_BY_ID = new Object2ObjectOpenHashMap();
    private static final Map<class_2960, Integer> LOADING_PRIORITIES = new HashMap<class_2960, Integer>();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public OriginLayerManager() {
        super(GSON, "origin_layers", class_3264.field_14190);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(OriginManager.ID, ID);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(ID, (player, joined) -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
            OriginLayerManager.values().stream().filter(OriginLayer::isEnabled).filter(Predicate.not(component::hasOrigin)).forEach(layer -> component.setOrigin((OriginLayer)layer, Origin.EMPTY));
            OriginLayerManager.send(player);
            this.updateData(player, joined);
        });
    }

    private void updateData(class_3222 player, boolean init) {
        class_6903 jsonOps = player.method_56673().method_57093((DynamicOps)JsonOps.INSTANCE);
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        int mismatches = 0;
        for (Map.Entry<OriginLayer, Origin> entry : component.getOrigins().entrySet()) {
            JsonElement newOriginJson;
            OriginLayer oldLayer = entry.getKey();
            OriginLayer newLayer = OriginLayerManager.getNullable(oldLayer.getId());
            Origin oldOrigin = entry.getValue();
            Origin newOrigin = OriginManager.getNullable(oldOrigin.getId());
            if (oldOrigin == Origin.EMPTY) continue;
            if (newLayer == null) {
                Origins.LOGGER.error("Removed unregistered origin layer \"{}\" from player {}!", (Object)oldLayer.getId(), (Object)player.method_5477().getString());
                component.removeLayer(oldLayer);
                continue;
            }
            if (!newLayer.contains(oldOrigin) || newOrigin == null) {
                Origins.LOGGER.error("Removed unregistered origin \"{}\" from origin layer \"{}\" from player {}!", (Object)oldOrigin.getId(), (Object)oldLayer.getId(), (Object)player.method_5477().getString());
                component.setOrigin(newLayer, Origin.EMPTY);
                continue;
            }
            JsonElement oldOriginJson = (JsonElement)Origin.DATA_TYPE.write((DynamicOps)jsonOps, (Object)oldOrigin).getOrThrow(JsonParseException::new);
            if (oldOriginJson.equals(newOriginJson = (JsonElement)Origin.DATA_TYPE.write((DynamicOps)jsonOps, (Object)newOrigin).getOrThrow(JsonParseException::new))) continue;
            Origins.LOGGER.warn("Origin \"{}\" from player {} has mismatched data fields! Updating...", (Object)oldOrigin.getId(), (Object)player.method_5477().getString());
            ++mismatches;
            component.setOrigin(newLayer, newOrigin);
        }
        if (mismatches > 0) {
            Origins.LOGGER.info("Finished updating {} origins with mismatched data fields from player {}!", (Object)mismatches, (Object)player.method_5477().getString());
        }
        if (component.hasAllOrigins()) {
            component.sync();
        } else {
            component.checkAutoChoosingLayers((class_1657)player, true);
            if (init) {
                if (component.hasAllOrigins()) {
                    OriginComponent.onChosen((class_1657)player, false);
                } else if (!CarpetIntegration.isPlayerFake(player)) {
                    component.selectingOrigin(true);
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenChooseOriginScreenS2CPacket(true));
                }
            }
            component.sync();
        }
    }

    protected void apply(MultiJsonDataContainer prepared, class_3300 manager, class_3695 profiler) {
        Origins.LOGGER.info("Reading origin layers from data packs...");
        class_5455 dynamicRegistries = CalioServer.getDynamicRegistries().orElse(null);
        OriginLayerManager.startBuilding();
        if (dynamicRegistries == null) {
            Origins.LOGGER.error("Can't read origin layers from data packs without access to dynamic registries!");
            OriginLayerManager.endBuilding();
            return;
        }
        HashMap<class_2960, List> loadedLayers = new HashMap<class_2960, List>();
        Origins.LOGGER.info("Reading origin layers from data packs...");
        prepared.forEach((packName, id, jsonElement) -> {
            try {
                SerializableData.CURRENT_NAMESPACE = id.method_12836();
                SerializableData.CURRENT_PATH = id.method_12832();
                if (!(jsonElement instanceof JsonObject)) {
                    throw new JsonSyntaxException("Not a JSON object: " + String.valueOf(jsonElement));
                }
                JsonObject jsonObject = (JsonObject)jsonElement;
                jsonObject.addProperty("id", id.toString());
                OriginLayer layer = (OriginLayer)OriginLayer.DATA_TYPE.read((DynamicOps)dynamicRegistries.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)jsonObject).getOrThrow();
                int currLoadingPriority = class_3518.method_15282((JsonObject)jsonObject, (String)"loading_priority", (int)0);
                PrioritizedEntry entry = new PrioritizedEntry((Object)layer, currLoadingPriority);
                int prevLoadingPriority = LOADING_PRIORITIES.getOrDefault(id, Integer.MIN_VALUE);
                if (layer.shouldReplace() && currLoadingPriority <= prevLoadingPriority) {
                    Origins.LOGGER.warn("Ignoring origin layer \"{}\" with 'replace' set to true from data pack [{}]. Its loading priority ({}) must be higher than {} to replace the origin layer!", (Object)id, (Object)packName, (Object)currLoadingPriority, (Object)prevLoadingPriority);
                } else {
                    List<String> invalidOrigins;
                    if (layer.shouldReplace()) {
                        Origins.LOGGER.info("Origin layer \"{}\" has been replaced by data pack [{}]!", (Object)id, (Object)packName);
                    }
                    if (!(invalidOrigins = layer.getConditionedOrigins().stream().map(OriginLayer.ConditionedOrigin::origins).flatMap(Collection::stream).filter(Predicate.not(OriginManager::contains)).map(class_2960::toString).toList()).isEmpty()) {
                        Origins.LOGGER.error("Origin layer \"{}\" contained {} invalid origin(s): {}", (Object)id, (Object)invalidOrigins.size(), (Object)String.join((CharSequence)", ", invalidOrigins));
                    }
                    loadedLayers.computeIfAbsent(id, k -> new LinkedList()).add(entry);
                    LOADING_PRIORITIES.put(id, currLoadingPriority);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading origin layer \"{}\": {}", (Object)id, (Object)e.getMessage());
            }
        });
        SerializableData.CURRENT_NAMESPACE = null;
        SerializableData.CURRENT_PATH = null;
        Origins.LOGGER.info("Finished reading {} origin layers. Merging similar origin layers...", (Object)loadedLayers.size());
        loadedLayers.forEach((id, entries) -> {
            AtomicReference<OriginLayer> currentLayer = new AtomicReference<OriginLayer>();
            entries.sort(Comparator.comparing(PrioritizedEntry::priority));
            for (PrioritizedEntry entry : entries) {
                if (currentLayer.get() == null) {
                    currentLayer.set((OriginLayer)entry.value());
                    continue;
                }
                currentLayer.accumulateAndGet((OriginLayer)entry.value(), OriginLayerManager::merge);
            }
            LAYERS_BY_ID.put(id, (Object)((OriginLayer)currentLayer.get()));
        });
        OriginLayerManager.endBuilding();
        Origins.LOGGER.info("Finished merging similar origin layers. Registry contains {} origin layers.", (Object)OriginLayerManager.size());
        ((OriginDataLoadedCallback)OriginDataLoadedCallback.EVENT.invoker()).onDataLoaded(false);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return DEPENDENCIES;
    }

    private static OriginLayer merge(OriginLayer oldLayer, OriginLayer newLayer) {
        if (newLayer.shouldReplace()) {
            return newLayer;
        }
        ObjectLinkedOpenHashSet origins = new ObjectLinkedOpenHashSet(oldLayer.getConditionedOrigins());
        ObjectLinkedOpenHashSet originsExcludedFromRandom = new ObjectLinkedOpenHashSet(oldLayer.getOriginsExcludedFromRandom());
        if (newLayer.shouldReplaceOrigins()) {
            origins.clear();
        }
        if (newLayer.shouldReplaceExcludedOriginsFromRandom()) {
            originsExcludedFromRandom.clear();
        }
        origins.addAll(newLayer.getConditionedOrigins());
        originsExcludedFromRandom.addAll(newLayer.getOriginsExcludedFromRandom());
        return new OriginLayer(oldLayer.getId(), oldLayer.getOrder(), (Collection<OriginLayer.ConditionedOrigin>)origins, newLayer.shouldReplaceOrigins(), newLayer.shouldReplace(), oldLayer.isEnabled(), oldLayer.getName(), oldLayer.getGuiTitle(), oldLayer.getMissingName(), oldLayer.getMissingDescription(), oldLayer.isRandomAllowed(), oldLayer.isUnchoosableRandomAllowed(), (Collection<class_2960>)originsExcludedFromRandom, newLayer.shouldReplaceExcludedOriginsFromRandom(), oldLayer.getDefaultOrigin(), oldLayer.shouldAutoChoose(), oldLayer.isHidden());
    }

    public static DataResult<OriginLayer> getResult(class_2960 id) {
        return LAYERS_BY_ID.containsKey((Object)id) ? DataResult.success((Object)((OriginLayer)LAYERS_BY_ID.get((Object)id))) : DataResult.error(() -> "Could not get layer from id '" + id.toString() + "', as it doesn't exist!");
    }

    public static Optional<OriginLayer> getOptional(class_2960 id) {
        return OriginLayerManager.getResult(id).result();
    }

    @Nullable
    public static OriginLayer getNullable(class_2960 id) {
        return (OriginLayer)LAYERS_BY_ID.get((Object)id);
    }

    public static OriginLayer get(class_2960 id) {
        return (OriginLayer)OriginLayerManager.getResult(id).getOrThrow();
    }

    public static Set<Map.Entry<class_2960, OriginLayer>> entrySet() {
        return new ObjectOpenHashSet((ObjectCollection)LAYERS_BY_ID.entrySet());
    }

    public static Set<class_2960> keySet() {
        return new ObjectOpenHashSet((ObjectCollection)LAYERS_BY_ID.keySet());
    }

    public static Collection<OriginLayer> values() {
        return new ObjectOpenHashSet(LAYERS_BY_ID.values());
    }

    public static boolean contains(OriginLayer layer) {
        return OriginLayerManager.contains(layer.getId());
    }

    public static boolean contains(class_2960 id) {
        return LAYERS_BY_ID.containsKey((Object)id);
    }

    public static int getOriginOptionCount(class_1657 playerEntity) {
        return OriginLayerManager.getOriginOptionCount(playerEntity, (layer, component) -> !component.hasOrigin((OriginLayer)layer));
    }

    public static int getOriginOptionCount(class_1657 playerEntity, BiPredicate<OriginLayer, OriginComponent> condition) {
        return OriginLayerManager.values().stream().filter(ol -> ol.isEnabled() && ModComponents.ORIGIN.maybeGet((Object)playerEntity).map(oc -> condition.test((OriginLayer)ol, (OriginComponent)oc)).orElse(false) != false).flatMapToInt(ol -> IntStream.of(ol.getOriginOptionCount(playerEntity))).sum();
    }

    public static int size() {
        return LAYERS_BY_ID.size();
    }

    private static void startBuilding() {
        LOADING_PRIORITIES.clear();
        LAYERS_BY_ID.clear();
    }

    private static void endBuilding() {
        LOADING_PRIORITIES.clear();
        LAYERS_BY_ID.trim();
    }

    public static void send(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncOriginLayersS2CPacket((Map<class_2960, OriginLayer>)LAYERS_BY_ID));
    }

    @Environment(value=EnvType.CLIENT)
    public static void receive(SyncOriginLayersS2CPacket packet, ClientPlayNetworking.Context context) {
        OriginLayerManager.startBuilding();
        LAYERS_BY_ID.putAll(packet.layersById());
        OriginLayerManager.endBuilding();
        ((OriginDataLoadedCallback)OriginDataLoadedCallback.EVENT.invoker()).onDataLoaded(true);
    }
}

