/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.type.Active;
import io.github.apace100.apoli.power.type.PowerType;
import io.github.apace100.apoli.util.keybinding.KeyBindingReference;
import io.github.apace100.apoli.util.keybinding.KeyBindingUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public class PowerKeyManager {
    private static final Map<class_2960, String> KEY_CACHE = new Object2ObjectOpenHashMap();

    public static void clearCache() {
        KEY_CACHE.clear();
    }

    public static Optional<String> getKeyId(Power power) {
        class_2960 powerId = power.getId();
        if (KEY_CACHE.containsKey(powerId)) {
            return Optional.ofNullable(KEY_CACHE.get(powerId));
        }
        return PowerKeyManager.getKeyFromPower(power).map(str -> KEY_CACHE.computeIfAbsent(powerId, id -> str));
    }

    private static Optional<String> getKeyFromPower(Power power) {
        PowerType powerType = power.getPowerType();
        if (powerType instanceof Active) {
            Active activePowerType = (Active)powerType;
            KeyBindingReference keyBindingReference = activePowerType.getKey();
            String keyId = keyBindingReference.id();
            if (KeyBindingUtil.ALIASES.hasAlias(keyId)) {
                keyId = KeyBindingUtil.ALIASES.resolveAlias(keyId);
            }
            return Optional.of(keyId);
        }
        return Optional.empty();
    }
}

