/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.platform;

import com.google.common.base.Strings;
import dev.upcraft.sparkweave.api.annotation.CallerSensitive;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import dev.upcraft.sparkweave.api.reflect.ContextHelper;
import org.jetbrains.annotations.Nullable;

public class Env {
    @Nullable
    @CallerSensitive
    public static String get(String name) {
        Class<?> caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        ModContainer ctx = ContextHelper.getContext(caller);
        return Env.get(name, ctx.metadata().id());
    }

    @Nullable
    public static String get(String name, String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return System.getProperty(name);
        }
        return System.getProperty(prefix + "." + name);
    }

    @CallerSensitive
    public static boolean getBool(String name) {
        Class<?> caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        ModContainer ctx = ContextHelper.getContext(caller);
        return Env.getBool(name, ctx.metadata().id());
    }

    public static boolean getBool(String name, String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return Boolean.getBoolean(name);
        }
        return Boolean.getBoolean(prefix + "." + name);
    }

    @CallerSensitive
    public static int getInt(String name) {
        Class<?> caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        ModContainer ctx = ContextHelper.getContext(caller);
        return Env.getInt(name, ctx.metadata().id());
    }

    public static int getInt(String name, String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return Integer.getInteger(name, 0);
        }
        return Integer.getInteger(prefix + "." + name, 0);
    }
}

