/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.serialization;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;

public class CSVWriter
implements AutoCloseable {
    public static final String DEFAULT_SEPARATOR = ",";
    private final String[] columns;
    private final List<String[]> rows = new LinkedList<String[]>();
    private final String separator;
    private final AtomicBoolean hasRowBuilder = new AtomicBoolean(false);
    private final PrintWriter output;

    private CSVWriter(OutputStream output, String[] columns, String separator) {
        Preconditions.checkArgument((columns.length > 0 ? 1 : 0) != 0, (Object)"no columns provided");
        Preconditions.checkArgument((!separator.isEmpty() ? 1 : 0) != 0, (Object)"separator must not be empty");
        Preconditions.checkArgument((!"\"".equals(separator) ? 1 : 0) != 0, (Object)"separator must not be double quotes");
        this.columns = columns;
        this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8)));
        this.separator = separator;
        this.printRow(columns);
    }

    public CSVWriter addRow(Object ... values) {
        Preconditions.checkArgument((values.length == this.columns.length ? 1 : 0) != 0, (String)"expected %s columns but got %s", (int)this.columns.length, (int)values.length);
        Preconditions.checkArgument((!this.hasRowBuilder.get() ? 1 : 0) != 0, (Object)"already building row");
        this.printRow(values);
        return this;
    }

    private void printRow(Object[] row) {
        StringJoiner result = new StringJoiner(this.separator);
        for (Object entry : row) {
            result.add(CSVWriter.quoteCSV(String.valueOf(entry), this.separator));
        }
        this.output.println(result);
    }

    public RowBuilder beginRow() {
        Preconditions.checkState((boolean)this.hasRowBuilder.getAndSet(true), (Object)"already building row");
        return new RowBuilder(this, this.columns.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns.length).add("rows", this.rows.size()).toString();
    }

    public static CSVWriter create(OutputStream destination, String firstColumn, String ... otherColumns) {
        String[] columns = new String[otherColumns.length + 1];
        System.arraycopy(otherColumns, 0, columns, 1, otherColumns.length);
        columns[0] = firstColumn;
        return new CSVWriter(destination, columns, DEFAULT_SEPARATOR);
    }

    public static CSVWriter create(OutputStream destination, String[] columns) {
        return new CSVWriter(destination, columns, DEFAULT_SEPARATOR);
    }

    public static CSVWriter withSeparator(OutputStream destination, String separator, String firstColumn, String ... otherColumns) {
        String[] columns = new String[otherColumns.length + 1];
        System.arraycopy(otherColumns, 0, columns, 1, otherColumns.length);
        columns[0] = firstColumn;
        return new CSVWriter(destination, columns, separator);
    }

    public static CSVWriter withSeparator(OutputStream destination, String separator, String[] columns) {
        return new CSVWriter(destination, columns, separator);
    }

    private static String quoteCSV(String input, String separator) {
        Object result = input;
        boolean needsQuote = input.contains(separator);
        if (input.contains("\"") && !"\"".equals(separator)) {
            needsQuote = true;
            result = ((String)result).replace("\"", "\"\"");
        }
        if (needsQuote) {
            result = "\"" + (String)result + "\"";
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.output);
    }

    public static class RowBuilder {
        private final CSVWriter csv;
        private final String[] rowData;
        private int idx = 0;

        private RowBuilder(CSVWriter csv, int columns) {
            this.csv = csv;
            this.rowData = new String[columns];
        }

        public RowBuilder add(String value) {
            Preconditions.checkState((this.idx < this.rowData.length - 1 ? 1 : 0) != 0, (Object)"too many columns");
            this.rowData[this.idx++] = value;
            return this;
        }

        public RowBuilder add(String first, String ... rest) {
            Preconditions.checkState((this.idx + rest.length < this.rowData.length - 1 ? 1 : 0) != 0, (Object)"too many columns");
            this.add(first);
            for (String value : rest) {
                this.add(value);
            }
            return this;
        }

        public CSVWriter end() {
            this.csv.printRow(this.rowData);
            this.csv.hasRowBuilder.set(false);
            return this.csv;
        }
    }
}

