/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.client.event;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import dev.upcraft.sparkweave.api.client.render.CustomArmorRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ArmorRendererRegistry {
    private static final Map<Pair<Class<? extends class_1309>, class_1792>, Optional<CustomArmorRenderer<? extends class_1309, ? extends class_583<?>>>> RENDERERS = new Object2ObjectOpenHashMap();
    private static final Map<class_1792, CustomArmorRenderer.Factory<? extends class_1309, ? extends class_583<?>>> FACTORIES = new Object2ObjectOpenHashMap();

    public static <E extends class_1309, M extends class_583<E>> void register(CustomArmorRenderer.Factory<E, M> factory, Supplier<? extends class_1935>[] items) {
        Preconditions.checkArgument((items.length > 0 ? 1 : 0) != 0, (Object)"Custom armor renderer registered, but no items are attached to it");
        for (Supplier<? extends class_1935> supplier : items) {
            Preconditions.checkNotNull(supplier, (Object)"Armor item is null or doesn't exist");
            class_1792 item = (class_1792)Preconditions.checkNotNull((Object)supplier.get().method_8389(), (Object)"Armor item is null or doesn't exist");
            if (FACTORIES.putIfAbsent(item, factory) == null) continue;
            throw new IllegalArgumentException("Custom armor renderer already exists for " + String.valueOf(class_7923.field_41178.method_10221((Object)item)));
        }
    }

    public static <E extends class_1309, M extends class_583<E>> void register(CustomArmorRenderer.Factory<E, M> factory, class_1935[] items) {
        Supplier[] suppliers = (Supplier[])Arrays.stream(items).map(itemLike -> () -> itemLike).toArray(Supplier[]::new);
        ArmorRendererRegistry.register(factory, suppliers);
    }

    public static <E extends class_1309, M extends class_583<E>> Optional<CustomArmorRenderer<E, M>> get(class_3883<E, M> renderer, E entity, class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return RENDERERS.computeIfAbsent((Pair<Class<? extends class_1309>, class_1792>)Pair.of(entity.getClass(), (Object)stack.method_7909()), key -> {
            CustomArmorRenderer.Factory<class_1309, class_583<?>> factory = FACTORIES.get(key.getSecond());
            if (factory == null) {
                return Optional.empty();
            }
            class_310 mc = class_310.method_1551();
            class_5617.class_5618 ctx = new class_5617.class_5618(mc.method_1561(), mc.method_1480(), mc.method_1541(), mc.method_1561().method_43336(), mc.method_1478(), mc.method_31974(), mc.field_1772);
            return Optional.ofNullable(factory.create(entity, ctx, renderer));
        });
    }

    public static void prepare() {
        FACTORIES.clear();
        RENDERERS.clear();
    }
}

