/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.fluid;

import io.github.fabricators_of_create.porting_lib.transfer.MutableContainerItemContext;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.class_1268;
import net.minecraft.class_128;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.p3pp3rf1y.sophisticatedcore.fluid.FluidActionResult;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class FluidUtil {
    public static final long BUCKET_VOLUME_IN_MILLIBUCKETS = 81L;

    public static int toBuckets(long amount) {
        return (int)(amount / 81L);
    }

    public static boolean isFluidStorage(class_1799 stack) {
        return ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
    }

    public static boolean placeFluid(@Nullable class_1657 player, @NotNull class_1937 level, @NotNull class_2338 pos, Storage<FluidVariant> source, FluidVariant resource, long maxAmount) {
        if (!level.method_8477(pos)) {
            return false;
        }
        class_3611 fluid = resource.getFluid();
        if (fluid == class_3612.field_15906) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        if (!waterlog && !state.method_45474()) {
            return false;
        }
        if (waterlog && fluid != class_3612.field_15910) {
            return false;
        }
        class_3610 fluidState = state.method_26227();
        if (!fluidState.method_15769() && fluidState.method_15772() != fluid) {
            return false;
        }
        try (Transaction extraction = Transaction.openOuter();){
            long result = source.extract((Object)resource, maxAmount, (TransactionContext)extraction);
            if (result == 0L) {
                boolean bl = false;
                return bl;
            }
            extraction.commit();
        }
        if (level.method_8597().comp_644() && fluid.method_15785().method_15767(class_3486.field_15517)) {
            level.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (waterlog) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            level.method_39281(pos, (class_3611)class_3612.field_15910, 1);
            return true;
        }
        if (!level.field_9236 && state.method_26188(fluid) && !state.method_51176()) {
            level.method_22352(pos, true);
        }
        if (level.method_8652(pos, fluid.method_15785().method_15759(), 3) || fluidState.method_15771()) {
            FluidUtil.playFluidSound(player, (class_1936)level, pos, resource, false);
            return true;
        }
        return false;
    }

    public static void playFluidSound(@Nullable class_1657 player, class_1936 level, class_2338 pos, FluidVariant resource, boolean fill) {
        class_3414 sound = fill ? FluidVariantAttributes.getFillSound((FluidVariant)resource) : FluidVariantAttributes.getEmptySound((FluidVariant)resource);
        level.method_8396(player, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28166, pos);
    }

    public static boolean interactWithFluidStorage(Storage<FluidVariant> storage, class_1657 player, class_1268 hand, boolean fill) {
        Storage handStorage = (Storage)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand).find(FluidStorage.ITEM);
        if (handStorage == null) {
            return false;
        }
        class_1792 handItem = player.method_5998(hand).method_7909();
        try {
            if (fill) {
                return FluidUtil.moveWithSound(storage, (Storage<FluidVariant>)handStorage, Long.MAX_VALUE, player, true, handItem, null);
            }
            return FluidUtil.moveWithSound((Storage<FluidVariant>)handStorage, storage, Long.MAX_VALUE, player, false, handItem, null);
        }
        catch (Exception e) {
            class_128 report = class_128.method_560((Throwable)e, (String)"Interacting with fluid storage");
            report.method_562("Interaction details").method_577("Player", () -> DebugMessages.forPlayer((class_1657)player)).method_578("Hand", (Object)hand).method_577("Hand item", () -> ((class_1792)handItem).toString()).method_577("Fluid storage", () -> Objects.toString(storage, null));
            throw new class_148(report);
        }
    }

    private static boolean moveWithSound(Storage<FluidVariant> from, Storage<FluidVariant> to, long maxAmount, @Nullable class_1657 player, boolean fill, class_1792 handItem, @Nullable Transaction ctx) {
        for (StorageView view : from) {
            long maxExtracted;
            if (view.isResourceBlank()) continue;
            FluidVariant resource = (FluidVariant)view.getResource();
            try (Transaction extractionTestTransaction = Transaction.openNested((TransactionContext)ctx);){
                maxExtracted = view.extract((Object)resource, maxAmount, (TransactionContext)extractionTestTransaction);
            }
            Transaction transferTransaction = Transaction.openNested((TransactionContext)ctx);
            try {
                class_3414 sound;
                long accepted = to.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                if (accepted <= 0L || view.extract((Object)resource, accepted, (TransactionContext)transferTransaction) != accepted) continue;
                transferTransaction.commit();
                class_3414 class_34142 = sound = fill ? FluidVariantAttributes.getFillSound((FluidVariant)resource) : FluidVariantAttributes.getEmptySound((FluidVariant)resource);
                if (resource.isOf((Object)class_3612.field_15910)) {
                    if (fill && handItem == class_1802.field_8469) {
                        sound = class_3417.field_14779;
                    }
                    if (!fill && handItem == class_1802.field_8574) {
                        sound = class_3417.field_14826;
                    }
                }
                if (player != null) {
                    player.method_17356(sound, class_3419.field_15245, 1.0f, 1.0f);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }

    public static FluidActionResult tryFillContainer(class_1799 container, Storage<FluidVariant> fluidSource, long maxAmount, @Nullable class_1657 player, boolean doFill) {
        class_1799 containerCopy = container.method_46651(1);
        MutableContainerItemContext context = new MutableContainerItemContext(containerCopy);
        Storage containerFluidHandler = (Storage)context.find(FluidStorage.ITEM);
        if (containerFluidHandler == null) {
            return FluidActionResult.FAILURE;
        }
        try (Transaction ctx = Transaction.openOuter();){
            boolean success = FluidUtil.moveWithSound(fluidSource, (Storage<FluidVariant>)containerFluidHandler, maxAmount, player, true, container.method_7909(), ctx);
            if (success) {
                if (doFill) {
                    ctx.commit();
                }
                FluidActionResult fluidActionResult = new FluidActionResult(context.getItemVariant().toStack((int)context.getAmount()));
                return fluidActionResult;
            }
        }
        return FluidActionResult.FAILURE;
    }

    public static FluidActionResult tryEmptyContainer(class_1799 container, Storage<FluidVariant> fluidDestination, long maxAmount, @Nullable class_1657 player, boolean doDrain) {
        class_1799 containerCopy = container.method_46651(1);
        MutableContainerItemContext context = new MutableContainerItemContext(containerCopy);
        Storage containerFluidHandler = (Storage)context.find(FluidStorage.ITEM);
        if (containerFluidHandler == null) {
            return FluidActionResult.FAILURE;
        }
        try (Transaction ctx = Transaction.openOuter();){
            boolean success = FluidUtil.moveWithSound((Storage<FluidVariant>)containerFluidHandler, fluidDestination, maxAmount, player, false, container.method_7909(), ctx);
            if (success) {
                if (doDrain) {
                    ctx.commit();
                }
                FluidActionResult fluidActionResult = new FluidActionResult(context.getItemVariant().toStack((int)context.getAmount()));
                return fluidActionResult;
            }
        }
        return FluidActionResult.FAILURE;
    }

    public static FluidActionResult tryFillContainerAndStow(class_1799 container, Storage<FluidVariant> fluidSource, IInventoryHandlerHelper inventory, long maxAmount, @Nullable class_1657 player, boolean doFill) {
        if (container.method_7960()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.method_31549().field_7477) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.method_7947() == 1) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            class_1799 remainder;
            FluidActionResult filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = inventory.insertItem(filledSimulated.getResult(), true)).method_7960() || player != null)) {
                FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = inventory.insertItem(filledReal.getResult(), !doFill);
                if (!remainder.method_7960() && player != null && doFill) {
                    ItemHandlerHelper.giveItemToPlayer((class_1657)player, (class_1799)remainder);
                }
                class_1799 containerCopy = container.method_7972();
                containerCopy.method_7934(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    public static FluidActionResult tryEmptyContainerAndStow(class_1799 container, Storage<FluidVariant> fluidDestination, IInventoryHandlerHelper inventory, long maxAmount, @Nullable class_1657 player, boolean doDrain) {
        if (container.method_7960()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.method_31549().field_7477) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.method_7947() == 1) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            class_1799 remainder;
            FluidActionResult emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = inventory.insertItem(emptiedSimulated.getResult(), true)).method_7960() || player != null)) {
                FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = inventory.insertItem(emptiedReal.getResult(), !doDrain);
                if (!remainder.method_7960() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((class_1657)player, (class_1799)remainder);
                }
                class_1799 containerCopy = container.method_7972();
                containerCopy.method_7934(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    public static Optional<ResourceAmount<FluidVariant>> getFluidContained(class_1799 container) {
        if (!container.method_7960()) {
            container = container.method_46651(1);
            Optional<ResourceAmount> fluidContained = Optional.ofNullable((Storage)ContainerItemContext.withConstant((class_1799)container).find(FluidStorage.ITEM)).map(handler -> StorageUtil.findExtractableContent((Storage)handler, null));
            return fluidContained.filter(f -> !((FluidVariant)f.resource()).isBlank());
        }
        return Optional.empty();
    }
}

