/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.network.ConfigSyncPacket;
import virtuoel.pehkui.network.ConfigSyncPayload;
import virtuoel.pehkui.network.DebugPacket;
import virtuoel.pehkui.network.DebugPayload;
import virtuoel.pehkui.network.ScalePacket;
import virtuoel.pehkui.network.ScalePayload;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ScaleRenderUtils;
import virtuoel.pehkui.util.VersionUtils;

@ApiStatus.Internal
public class PehkuiClient
implements ClientModInitializer {
    public void onInitializeClient() {
        if (ModLoaderUtils.isModLoaded("fabric-networking-api-v1")) {
            if (VersionUtils.MINOR > 20 || VersionUtils.MINOR == 20 && VersionUtils.PATCH >= 5) {
                new Runnable(){

                    @Override
                    public void run() {
                        ClientPlayNetworking.registerGlobalReceiver(ScalePayload.ID, (payload, context) -> PehkuiClient.handleScalePacket(context.client(), payload));
                        ClientPlayNetworking.registerGlobalReceiver(ConfigSyncPayload.ID, (payload, context) -> context.client().execute(payload.action));
                        ClientPlayNetworking.registerGlobalReceiver(DebugPayload.ID, (payload, context) -> PehkuiClient.handleDebugPacket(context.client(), payload.type));
                    }
                }.run();
            } else {
                ScaleRenderUtils.registerPacketHandler(Pehkui.SCALE_PACKET, PehkuiClient.class, "handleScalePacket");
                ScaleRenderUtils.registerPacketHandler(Pehkui.CONFIG_SYNC_PACKET, PehkuiClient.class, "handleConfigSyncPacket");
                ScaleRenderUtils.registerPacketHandler(Pehkui.DEBUG_PACKET, PehkuiClient.class, "handleDebugPacket");
            }
        } else {
            Pehkui.LOGGER.error("Failed to register Pehkui's packet handlers! Is Fabric API's networking module missing?", new Object[0]);
        }
    }

    public static void handleScalePacket(class_310 client, class_634 handler, class_2540 buf, Object responseSender) {
        PehkuiClient.handleScalePacket(client, new ScalePacket(buf));
    }

    protected static void handleScalePacket(class_310 client, ScalePacket packet) {
        client.execute(() -> {
            class_1297 e = client.field_1687.method_8469(packet.entityId);
            if (e != null) {
                packet.syncedScales.forEach((typeId, scaleData) -> {
                    if (ScaleRegistries.SCALE_TYPES.containsKey(typeId)) {
                        ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, typeId).getScaleData(e).readNbt((class_2487)scaleData);
                    }
                });
            }
        });
    }

    public static void handleConfigSyncPacket(class_310 client, class_634 handler, class_2540 buf, Object responseSender) {
        client.execute(new ConfigSyncPacket((class_2540)buf).action);
    }

    public static void handleDebugPacket(class_310 client, class_634 handler, class_2540 buf, Object responseSender) {
        PehkuiClient.handleDebugPacket(client, new DebugPacket((class_2540)buf).type);
    }

    protected static void handleDebugPacket(class_310 client, DebugCommand.PacketType type) {
        client.execute(() -> {
            switch (type) {
                case MIXIN_AUDIT: {
                    client.field_1724.method_7353(I18nUtils.translate("commands.pehkui.debug.audit.start.client", "Starting Mixin environment audit (client)..."), false);
                    MixinEnvironment.getCurrentEnvironment().audit();
                    client.field_1724.method_7353(I18nUtils.translate("commands.pehkui.debug.audit.end.client", "Mixin environment audit (client) complete!"), false);
                    break;
                }
                case GARBAGE_COLLECT: {
                    System.gc();
                    break;
                }
            }
        });
    }
}

