/*
 * Decompiled with CFR 0.152.
 */
package com.kio7po.originsfurs.fabric.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kio7po.originsfurs.fabric.client.bridge.IPlayerEntityModel;
import com.kio7po.originsfurs.fabric.client.model.OriginFurAnimatable;
import com.kio7po.originsfurs.fabric.client.util.Alib;
import io.github.apace100.apoli.power.PowerManager;
import io.github.apace100.origins.origin.Origin;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import java.util.EnumSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_742;
import org.joml.Vector3d;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

@Environment(value=EnvType.CLIENT)
public class OriginFurModel
extends GeoModel<OriginFurAnimatable> {
    public static final Vector3d VECTOR3D_ZERO = new Vector3d();
    public static final Vector3f VECTOR3F_ZERO = new Vector3f();
    public static final class_2960 MISSING_MODEL = class_2960.method_12829((String)"originsfurs:geo/missing.geo.json");
    public static final class_2960 MISSING_TEXTURE = class_2960.method_12829((String)"originsfurs:textures/missing.png");
    public static final class_2960 MISSING_ANIMATION = class_2960.method_12829((String)"originsfurs:animations/missing.animation.json");
    public JsonObject json;
    private class_2960 model;
    private class_2960 texture;
    private class_2960 textureGlowmask;
    private class_2960 elytraTexture;
    private class_2960 overlayTexture;
    private class_2960 overlayTextureSlim;
    private class_2960 emissiveOverlayTexture;
    private class_2960 emissiveOverlayTextureSlim;
    private class_2960 animation;
    private Vector3d rightHeldItemOffset = VECTOR3D_ZERO;
    private Vector3d leftHeldItemOffset = VECTOR3D_ZERO;
    public EnumSet<VMP> hiddenParts = EnumSet.noneOf(VMP.class);
    private Origin origin;
    public Long2ReferenceLinkedOpenHashMap<GeoBone> boneCache = new Long2ReferenceLinkedOpenHashMap();

    public OriginFurModel(Origin origin, JsonObject json) {
        this.origin = origin;
        this.recompile(json);
    }

    public void recompile(JsonObject json) {
        this.parseJson(json);
        this.boneCache.clear();
    }

    public void parseJson(JsonObject json) {
        this.json = json;
        this.parseModel();
        this.parseTexture();
        this.parseTextureGlowmask();
        this.parseAnimation();
        this.parseHiddenParts();
        this.parseOverlayTexture();
        this.parseEmissiveOverlayTexture();
        this.parseElytraTexture();
        this.parseHeldItemOffsets();
    }

    private void parseModel() {
        this.model = class_3518.method_15289((JsonObject)this.json, (String)"model") ? class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"model")) : MISSING_MODEL;
    }

    private void parseTexture() {
        this.texture = class_3518.method_15289((JsonObject)this.json, (String)"texture") ? class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"texture")) : MISSING_TEXTURE;
    }

    private void parseTextureGlowmask() {
        if (class_3518.method_15289((JsonObject)this.json, (String)"texture_glowmask")) {
            this.textureGlowmask = class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"texture_glowmask"));
        }
    }

    private void parseAnimation() {
        this.animation = class_3518.method_15289((JsonObject)this.json, (String)"animation") ? class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"animation")) : MISSING_ANIMATION;
    }

    private void parseHiddenParts() {
        EnumSet<VMP> set = EnumSet.noneOf(VMP.class);
        if (this.json.has("hidden")) {
            JsonArray hiddenParts = this.json.getAsJsonArray("hidden");
            hiddenParts.forEach(hiddenPart -> {
                switch (hiddenPart.getAsString().toLowerCase()) {
                    case "rightsleeve": {
                        set.add(VMP.RIGHT_SLEEVE);
                        break;
                    }
                    case "leftsleeve": {
                        set.add(VMP.LEFT_SLEEVE);
                        break;
                    }
                    case "rightarm": {
                        set.add(VMP.RIGHT_ARM);
                        break;
                    }
                    case "leftarm": {
                        set.add(VMP.LEFT_ARM);
                        break;
                    }
                    case "rightpants": {
                        set.add(VMP.RIGHT_PANTS);
                        break;
                    }
                    case "leftpants": {
                        set.add(VMP.LEFT_PANTS);
                        break;
                    }
                    case "rightleg": {
                        set.add(VMP.RIGHT_LEG);
                        break;
                    }
                    case "leftleg": {
                        set.add(VMP.LEFT_LEG);
                        break;
                    }
                    case "hat": {
                        set.add(VMP.HAT);
                        break;
                    }
                    case "head": {
                        set.add(VMP.HEAD);
                        break;
                    }
                    case "jacket": {
                        set.add(VMP.JACKET);
                        break;
                    }
                    case "body": {
                        set.add(VMP.BODY);
                    }
                }
            });
        }
        this.hiddenParts = set;
    }

    private void parseElytraTexture() {
        if (class_3518.method_15289((JsonObject)this.json, (String)"elytra_texture")) {
            this.elytraTexture = class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"elytra_texture"));
        }
    }

    private void parseOverlayTexture() {
        if (class_3518.method_15289((JsonObject)this.json, (String)"overlay")) {
            this.overlayTexture = class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"overlay"));
        }
        if (class_3518.method_15289((JsonObject)this.json, (String)"overlay_slim")) {
            this.overlayTextureSlim = class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"overlay_slim"));
        }
    }

    private void parseEmissiveOverlayTexture() {
        if (class_3518.method_15289((JsonObject)this.json, (String)"emissive_overlay")) {
            this.emissiveOverlayTexture = class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"emissive_overlay"));
        }
        if (class_3518.method_15289((JsonObject)this.json, (String)"emissive_overlay_slim")) {
            this.emissiveOverlayTextureSlim = class_2960.method_12829((String)class_3518.method_15265((JsonObject)this.json, (String)"emissive_overlay_slim"));
        }
    }

    private void parseHeldItemOffsets() {
        if (class_3518.method_34923((JsonObject)this.json, (String)"held_item_offsets")) {
            JsonObject offsets = this.json.getAsJsonObject("held_item_offsets");
            if (class_3518.method_15264((JsonObject)offsets, (String)"right")) {
                this.rightHeldItemOffset = Alib.jsonToVector3d(offsets.get("right"));
            }
            if (class_3518.method_15264((JsonObject)offsets, (String)"left")) {
                this.leftHeldItemOffset = Alib.jsonToVector3d(offsets.get("left"));
            }
        }
    }

    public class_2960 getModelResource(OriginFurAnimatable animatable) {
        return this.model;
    }

    public class_2960 getTextureResource(OriginFurAnimatable animatable) {
        return this.texture;
    }

    public class_2960 getTextureGlowmaskResource() {
        return this.textureGlowmask;
    }

    public class_2960 getAnimationResource(OriginFurAnimatable animatable) {
        return this.animation;
    }

    public final GeoBone getCachedGeoBone(String identifier) {
        long hash = Alib.getHash64(identifier);
        if (this.boneCache.containsKey(hash)) {
            return (GeoBone)this.boneCache.get(hash);
        }
        GeoBone bone = this.getBone(identifier).orElse(null);
        if (bone != null) {
            this.boneCache.putAndMoveToFirst(hash, (Object)bone);
            return bone;
        }
        return null;
    }

    private Vector3d getHeldItemOffset(String id) {
        return switch (id) {
            case "right" -> this.rightHeldItemOffset;
            case "left" -> this.leftHeldItemOffset;
            default -> null;
        };
    }

    public final Vector3d getRightOffset() {
        return this.getHeldItemOffset("right");
    }

    public final Vector3d getLeftOffset() {
        return this.getHeldItemOffset("left");
    }

    public boolean hasCustomElytraTexture() {
        return this.elytraTexture != null;
    }

    public class_2960 getElytraTexture() {
        return this.elytraTexture;
    }

    public class_2960 getOverlayTexture(boolean isSlim) {
        if (!isSlim || this.overlayTextureSlim == null) {
            return this.overlayTexture;
        }
        return this.overlayTextureSlim;
    }

    public class_2960 getEmissiveOverlayTexture(boolean isSlim) {
        if (!isSlim || this.emissiveOverlayTextureSlim == null) {
            return this.emissiveOverlayTexture;
        }
        return this.emissiveOverlayTextureSlim;
    }

    public final boolean isPlayerModelInvisible() {
        return class_3518.method_15258((JsonObject)this.json, (String)"playerInvisible", (boolean)false);
    }

    public EnumSet<VMP> getHiddenVanillaParts() {
        return this.hiddenParts;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void preprocess(IPlayerEntityModel playerEntityModel, class_742 abstractClientPlayerEntity) {
        this.getAnimationProcessor().getRegisteredBones().forEach(coreGeoBone -> {
            coreGeoBone.setHidden(false);
            String boneName = coreGeoBone.getName();
            coreGeoBone.setHidden(this.shouldHideBone(boneName, playerEntityModel, abstractClientPlayerEntity));
        });
    }

    private boolean shouldHideBone(String boneName, IPlayerEntityModel playerEntityModel, class_742 player) {
        return this.isThinHiddenBone(boneName, playerEntityModel) || this.isWideHiddenBone(boneName, playerEntityModel) || this.isElytraHiddenBone(boneName, player) || this.isArmorHiddenBone(boneName, player) || this.isModHiddenBone(boneName);
    }

    private boolean isThinHiddenBone(String boneName, IPlayerEntityModel model) {
        return boneName.endsWith("thin_only") && !model.originsfurs$isSlim();
    }

    private boolean isWideHiddenBone(String boneName, IPlayerEntityModel model) {
        return boneName.endsWith("wide_only") && model.originsfurs$isSlim();
    }

    private boolean isElytraHiddenBone(String boneName, class_742 player) {
        return boneName.contains("elytra_hides") && (this.origin.hasPower(PowerManager.get((class_2960)class_2960.method_60654((String)"origins:elytra"))) || player.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833));
    }

    private boolean isArmorHiddenBone(String boneName, class_742 player) {
        return boneName.contains("helmet_hides") && !player.method_6118(class_1304.field_6169).method_7960() || boneName.contains("chestplate_hides") && !player.method_6118(class_1304.field_6174).method_7960() || boneName.contains("leggings_hides") && !player.method_6118(class_1304.field_6172).method_7960() || boneName.contains("boots_hides") && !player.method_6118(class_1304.field_6166).method_7960();
    }

    private boolean isModHiddenBone(String boneName) {
        return FabricLoader.getInstance().getAllMods().stream().anyMatch(mod -> boneName.contains("mod_hides_" + mod.getMetadata().getId()));
    }

    @Environment(value=EnvType.CLIENT)
    public static enum VMP {
        LEFT_ARM,
        RIGHT_ARM,
        RIGHT_SLEEVE,
        LEFT_SLEEVE,
        RIGHT_LEG,
        LEFT_LEG,
        RIGHT_PANTS,
        LEFT_PANTS,
        HAT,
        HEAD,
        BODY,
        JACKET;

        public static final EnumSet<VMP> ALL_OPTS;

        static {
            ALL_OPTS = EnumSet.allOf(VMP.class);
        }
    }
}

