/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.origins.icarae.fabric.power;

import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.util.ServerPlayerFallbackValues;
import dev.upcraft.origins.icarae.IcaraeOrigin;
import dev.upcraft.origins.icarae.fabric.init.IcaraePowers;
import dev.upcraft.origins.icarae.fabric.util.CustomDataTypes;
import dev.upcraft.origins.icarae.util.OptionalBool;
import io.github.apace100.apoli.data.TypedDataObjectFactory;
import io.github.apace100.apoli.power.PowerConfiguration;
import io.github.apace100.apoli.power.type.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class WingsPower
extends PowerType
implements IcarusPlayerValues {
    public static final class_2960 POWER_TYPE_ID = IcaraeOrigin.id("wings");
    public static final TypedDataObjectFactory<WingsPower> DATA_FACTORY = PowerType.createConditionedDataFactory((SerializableData)new SerializableData().add("wings_type", CustomDataTypes.STACK_OR_ITEM_NAME).add("armor_slows", CustomDataTypes.OPTIONAL_BOOL, (Object)OptionalBool.DEFAULT).add("max_slowed_multiplier", CustomDataTypes.OPTIONAL_DOUBLE, (Object)OptionalDouble.empty()).add("wings_speed", CustomDataTypes.OPTIONAL_DOUBLE, (Object)OptionalDouble.empty()).add("exhaustion_amount", CustomDataTypes.OPTIONAL_DOUBLE, (Object)OptionalDouble.empty()).add("max_height_above_world", CustomDataTypes.OPTIONAL_INT, (Object)OptionalInt.empty()), (data, entityCondition) -> {
        class_1799 wingsType = (class_1799)data.get("wings_type");
        OptionalBool armorSlows = (OptionalBool)((Object)((Object)data.get("armor_slows")));
        OptionalDouble maxSlowedMultiplier = (OptionalDouble)data.get("max_slowed_multiplier");
        OptionalDouble wingsSpeed = (OptionalDouble)data.get("wings_speed");
        OptionalDouble exhaustionAmount = (OptionalDouble)data.get("exhaustion_amount");
        OptionalInt maxHeightAboveWorld = (OptionalInt)data.get("max_height_above_world");
        return new WingsPower(wingsType, armorSlows, maxSlowedMultiplier, wingsSpeed, exhaustionAmount, maxHeightAboveWorld);
    }, (wingsPower, serializableData) -> serializableData.instance().set("wings_type", (Object)wingsPower.wingsType).set("armor_slows", (Object)wingsPower.armorSlows).set("max_slowed_multiplier", (Object)wingsPower.maxSlowedMultiplier).set("wings_speed", (Object)wingsPower.wingsSpeed).set("exhaustion_amount", (Object)wingsPower.exhaustionAmount).set("max_height_above_world", (Object)wingsPower.maxHeightAboveWorld));
    private final class_1799 wingsType;
    private final OptionalBool armorSlows;
    private final OptionalDouble maxSlowedMultiplier;
    private final OptionalDouble wingsSpeed;
    private final OptionalDouble exhaustionAmount;
    private final OptionalInt maxHeightAboveWorld;
    private IcarusPlayerValues fallback = new ServerPlayerFallbackValues();

    public WingsPower(class_1799 wingsType, OptionalBool armorSlows, OptionalDouble maxSlowedMultiplier, OptionalDouble wingsSpeed, OptionalDouble exhaustionAmount, OptionalInt maxHeightAboveWorld) {
        this.wingsType = wingsType;
        this.armorSlows = armorSlows;
        this.maxSlowedMultiplier = maxSlowedMultiplier;
        this.wingsSpeed = wingsSpeed;
        this.exhaustionAmount = exhaustionAmount;
        this.maxHeightAboveWorld = maxHeightAboveWorld;
    }

    public class_1799 getWingsType() {
        return this.wingsType;
    }

    public void updateFallback(IcarusPlayerValues fallback) {
        this.fallback = fallback;
    }

    public float wingsSpeed() {
        return (float)this.wingsSpeed.orElseGet(() -> ((IcarusPlayerValues)this.fallback).wingsSpeed());
    }

    public float maxSlowedMultiplier() {
        return (float)this.maxSlowedMultiplier.orElseGet(() -> ((IcarusPlayerValues)this.fallback).maxSlowedMultiplier());
    }

    public boolean armorSlows() {
        return this.armorSlows.orElseGet(() -> ((IcarusPlayerValues)this.fallback).armorSlows());
    }

    public boolean canLoopDeLoop() {
        return this.fallback.canLoopDeLoop();
    }

    public boolean canSlowFall() {
        return this.fallback.canSlowFall();
    }

    public float exhaustionAmount() {
        return (float)this.exhaustionAmount.orElseGet(() -> ((IcarusPlayerValues)this.fallback).exhaustionAmount());
    }

    public int maxHeightAboveWorld() {
        return this.maxHeightAboveWorld.orElseGet(() -> ((IcarusPlayerValues)this.fallback).maxHeightAboveWorld());
    }

    public boolean maxHeightEnabled() {
        return this.maxHeightAboveWorld.isPresent() || this.fallback.maxHeightEnabled();
    }

    @NotNull
    public PowerConfiguration<?> getConfig() {
        return (PowerConfiguration)IcaraePowers.WINGS.get();
    }
}

