/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneActivatedEvent;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGeneratorManager;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlayerWaystoneManager {
    private static final IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static final IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean isWaystoneActivated(class_1657 player, Waystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(class_1657 player, Waystone waystone) {
        if (!waystone.hasName() && waystone instanceof MutableWaystone && waystone.wasGenerated()) {
            NameGenerationMode nameGenerationMode = WaystonesConfig.getActive().worldGen.nameGenerationMode;
            class_2561 name = NameGeneratorManager.get(player.method_5682()).getName((class_1936)player.method_37908(), waystone, player.method_37908().field_9229, nameGenerationMode);
            ((MutableWaystone)((Object)waystone)).setName(name);
        }
        if (!waystone.hasOwner() && waystone instanceof MutableWaystone) {
            MutableWaystone mutableWaystone = (MutableWaystone)((Object)waystone);
            mutableWaystone.setOwnerUid(player.method_5667());
            mutableWaystone.setVisibility(WaystonesConfig.getActive().general.defaultVisibility);
        }
        if (player.method_5682() != null) {
            WaystoneManagerImpl.get(player.method_5682()).method_80();
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).activateWaystone(player, waystone);
            Balm.getEvents().fireEvent((Object)new WaystoneActivatedEvent(player, waystone));
        }
    }

    public static Optional<Waystone> getInventoryButtonTarget(class_1657 player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return WaystoneManagerImpl.get(player.method_5682()).findWaystoneByName(inventoryButtonMode.getNamedTarget());
        }
        return Optional.empty();
    }

    public static void deactivateWaystone(class_1657 player, Waystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).deactivateWaystone(player, waystone);
    }

    public static Map<class_2960, Long> getCooldowns(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getCooldowns(player);
    }

    public static void resetCooldowns(class_1657 player) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).resetCooldowns(player);
    }

    public static long getCooldownUntil(class_1657 player, class_2960 key) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getCooldownUntil(player, key);
    }

    public static long getCooldownMillisLeft(class_1657 player, class_2960 key) {
        long cooldownUntil = PlayerWaystoneManager.getCooldownUntil(player, key);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setCooldownUntil(class_1657 player, class_2960 key, long timestamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).setCooldownUntil(player, key, timestamp);
    }

    public static Optional<Waystone> getNearestWaystone(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWaystones(player).stream().filter(it -> it.getDimension() == player.method_37908().method_27983()).min((first, second) -> {
            double firstDist = first.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321());
            double secondDist = second.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321());
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        });
    }

    public static Collection<Waystone> getActivatedWaystones(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(@Nullable class_1937 world) {
        return world == null || world.field_9236 ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(BalmEnvironment side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static List<UUID> getSortingIndex(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getSortingIndex(player);
    }

    public static List<UUID> ensureSortingIndex(class_1657 player, Collection<Waystone> waystones) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).ensureSortingIndex(player, waystones);
    }

    public static void sortWaystoneAsFirst(class_1657 player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).sortWaystoneAsFirst(player, waystoneUid);
    }

    public static void sortWaystoneAsLast(class_1657 player, UUID waystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).sortWaystoneAsLast(player, waystoneUid);
    }

    public static void sortWaystoneSwap(class_1657 player, UUID waystoneUid, UUID otherWaystoneUid) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).sortWaystoneSwap(player, waystoneUid, otherWaystoneUid);
    }

    public static void activeWaystoneForEveryone(@Nullable MinecraftServer server, Waystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((class_1657)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((class_1657)player, waystone);
        }
    }

    public static void removeKnownWaystone(@Nullable MinecraftServer server, Waystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            PlayerWaystoneManager.deactivateWaystone((class_1657)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
        }
    }

    public static Collection<Waystone> getTargetsForPlayer(class_1657 player) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<Waystone> getTargetsForItem(class_1657 player, class_1799 itemStack) {
        return PlayerWaystoneManager.getActivatedWaystones(player);
    }

    public static Collection<Waystone> getTargetsForWaystone(class_1657 player, Waystone waystone) {
        Collection<Waystone> result = PlayerWaystoneManager.getTargetsForWaystoneType(player, waystone.getWaystoneType());
        class_2586 blockEntity = player.method_37908().method_8321(waystone.getPos());
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntity = (WaystoneBlockEntityBase)blockEntity;
            result.addAll(waystoneBlockEntity.getAuxiliaryTargets());
        }
        return result;
    }

    public static Collection<Waystone> getTargetsForWaystoneType(class_1657 player, class_2960 waystoneType) {
        ArrayList<Waystone> result = new ArrayList<Waystone>();
        if (WaystoneTypes.isSharestone(waystoneType)) {
            result.addAll(WaystoneManagerImpl.get(player.method_5682()).getWaystonesByType(waystoneType).toList());
        } else {
            result.addAll(PlayerWaystoneManager.getActivatedWaystones(player));
        }
        return result;
    }

    public static Collection<Waystone> getTargetsForInventoryButton(class_3222 player) {
        return PlayerWaystoneManager.getActivatedWaystones((class_1657)player);
    }
}

