/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.action.ModBientityActionTypes;
import dev.muon.medievalorigins.util.SpellSchoolUtil;
import io.github.apace100.apoli.action.ActionConfiguration;
import io.github.apace100.apoli.action.context.BiEntityActionContext;
import io.github.apace100.apoli.action.type.BiEntityActionType;
import io.github.apace100.apoli.data.TypedDataObjectFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.NotNull;

public class SpellDamageActionType
extends BiEntityActionType {
    public static final TypedDataObjectFactory<SpellDamageActionType> DATA_FACTORY = TypedDataObjectFactory.simple((SerializableData)new SerializableData().add("magic_school", SerializableDataTypes.STRING).add("crit_behavior", SerializableDataTypes.STRING, (Object)"normal").add("base", SerializableDataTypes.FLOAT.optional(), Optional.empty()).add("scaling_factor", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("modifier", Modifier.DATA_TYPE, null).addFunctionedDefault("modifiers", Modifier.LIST_TYPE, data -> MiscUtil.singletonListOrNull((Object)((Modifier)data.get("modifier")))).add("damage_type", SerializableDataTypes.DAMAGE_TYPE).validate(MiscUtil.validateAnyFieldsPresent((String[])new String[]{"base", "modifier", "modifiers"})), data -> new SpellDamageActionType(data.getString("magic_school"), data.getString("crit_behavior"), (Optional)data.get("base"), data.getFloat("scaling_factor"), (List)data.get("modifiers"), (class_5321<class_8110>)((class_5321)data.get("damage_type"))), (type, data) -> data.instance().set("magic_school", (Object)type.magicSchool).set("crit_behavior", (Object)type.critBehavior).set("base", type.baseDamage).set("scaling_factor", (Object)Float.valueOf(type.scalingFactor)).set("modifiers", type.modifiers).set("damage_type", type.damageType));
    private final String magicSchool;
    private final String critBehavior;
    private final Optional<Float> baseDamage;
    private final float scalingFactor;
    private final List<Modifier> modifiers;
    private final class_5321<class_8110> damageType;

    public SpellDamageActionType(String magicSchool, String critBehavior, Optional<Float> baseDamage, float scalingFactor, List<Modifier> modifiers, class_5321<class_8110> damageType) {
        this.magicSchool = magicSchool;
        this.critBehavior = critBehavior;
        this.baseDamage = baseDamage;
        this.scalingFactor = scalingFactor;
        this.modifiers = modifiers;
        this.damageType = damageType;
    }

    public void accept(BiEntityActionContext context) {
        class_1297 actor = context.actor();
        class_1297 target = context.target();
        if (actor == null || target == null || actor.method_37908().method_8608() || target.method_37908().method_8608()) {
            return;
        }
        this.baseDamage.or(() -> this.getModifiedAmount(actor, target)).ifPresent(damage -> {
            float totalDamage = damage.floatValue();
            if (FabricLoader.getInstance().isModLoaded("spell_power")) {
                try {
                    SpellSchool school = SpellSchoolUtil.getSpellSchoolWithFallback(this.magicSchool);
                    SpellPower.Result spellPowerResult = SpellPower.getSpellPower((SpellSchool)school, (class_1309)((class_1309)actor));
                    double finalSpellPower = switch (this.critBehavior) {
                        case "always" -> spellPowerResult.forcedCriticalValue();
                        case "never" -> spellPowerResult.nonCriticalValue();
                        default -> spellPowerResult.randomValue();
                    };
                    totalDamage = (float)((double)totalDamage + finalSpellPower * (double)this.scalingFactor);
                }
                catch (IllegalArgumentException e) {
                    MedievalOrigins.LOGGER.warn("SpellDamageAction: Could not apply spell power scaling for school '{}' (actor: {}, target: {}). Error: {}", (Object)this.magicSchool, (Object)actor.method_5477().getString(), (Object)target.method_5477().getString(), (Object)e.getMessage());
                }
            }
            target.method_5643(actor.method_48923().method_48796(this.damageType, actor), totalDamage);
        });
    }

    private Optional<Float> getModifiedAmount(class_1297 actor, class_1297 target) {
        Optional<Float> optional;
        if (!this.modifiers.isEmpty() && target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            optional = Optional.of(Float.valueOf((float)ModifierUtil.applyModifiers((class_1297)actor, this.modifiers, (double)livingTarget.method_6063())));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @NotNull
    public ActionConfiguration<?> getConfig() {
        return ModBientityActionTypes.SPELL_DAMAGE;
    }
}

