/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.condition.bientity;

import dev.muon.medievalorigins.condition.ModBientityConditionTypes;
import dev.muon.medievalorigins.entity.SummonedMob;
import dev.muon.medievalorigins.util.AllianceUtil;
import io.github.apace100.apoli.condition.ConditionConfiguration;
import io.github.apace100.apoli.condition.context.BiEntityConditionContext;
import io.github.apace100.apoli.condition.type.BiEntityConditionType;
import io.github.apace100.apoli.data.TypedDataObjectFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.UUID;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;

public class AlliedConditionType
extends BiEntityConditionType {
    public static final TypedDataObjectFactory<AlliedConditionType> DATA_FACTORY = TypedDataObjectFactory.simple((SerializableData)new SerializableData(), data -> new AlliedConditionType(), (type, data) -> data.instance());

    public boolean test(BiEntityConditionContext context) {
        class_1297 actor = context.actor();
        class_1297 target = context.target();
        return AlliedConditionType.isAllied(actor, target);
    }

    public static boolean isAllied(class_1297 actor, class_1297 target) {
        UUID targetAffiliationId;
        if (actor == target) {
            return true;
        }
        if (actor instanceof SummonedMob) {
            SummonedMob summonedActor = (SummonedMob)actor;
            return SummonedMob.checkAllyStatus(summonedActor, target);
        }
        if (target instanceof SummonedMob) {
            SummonedMob summonedTarget = (SummonedMob)target;
            return SummonedMob.checkAllyStatus(summonedTarget, actor);
        }
        UUID actorAffiliationId = AllianceUtil.getPlayerAffiliationIdRecursive(actor);
        if (AllianceUtil.areEntitiesAlliedByFTBTeams(actorAffiliationId, targetAffiliationId = AllianceUtil.getPlayerAffiliationIdRecursive(target), actor.method_37908())) {
            return true;
        }
        return actor.method_5722(target);
    }

    @NotNull
    public ConditionConfiguration<?> getConfig() {
        return ModBientityConditionTypes.ALLIED;
    }
}

