/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.undo;

import dev.upcraft.sparkweave.api.undo.Action;
import java.util.LinkedList;

public class UndoRedoStack {
    private final LinkedList<Action> actions = new LinkedList();
    private int currentIndex = -1;

    public Action addAction(Action action) {
        if (this.currentIndex < this.actions.size() - 1) {
            this.actions.subList(this.currentIndex + 1, this.actions.size()).clear();
        }
        this.actions.add(action);
        ++this.currentIndex;
        return action;
    }

    public void undo() {
        if (this.currentIndex >= 0) {
            this.actions.get(this.currentIndex).undo();
            --this.currentIndex;
        }
    }

    public void redo() {
        if (this.currentIndex < this.actions.size() - 1) {
            ++this.currentIndex;
            this.actions.get(this.currentIndex).perform();
        }
    }

    public boolean canUndo() {
        return this.currentIndex >= 0;
    }

    public boolean canRedo() {
        return this.currentIndex < this.actions.size() - 1;
    }

    public void clear() {
        this.actions.clear();
        this.currentIndex = -1;
    }

    public int size() {
        return this.actions.size();
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public Action currentAction() {
        return this.actions.get(this.currentIndex);
    }

    public Action getAction(int index) {
        return this.actions.get(index);
    }
}

