/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.upcraft.sparkweave.api.command.CommandHelper;
import dev.upcraft.sparkweave.api.platform.Services;
import dev.upcraft.sparkweave.api.serialization.CSVWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.class_8786;

public class DumpRecipesCommand {
    private static final DynamicCommandExceptionType TYPE_NOT_FOUND = new DynamicCommandExceptionType(type -> class_2561.method_43469((String)"argument.sparkweave.debug.dump_recipes.type_not_found", (Object[])new Object[]{type}));

    public static void register(LiteralArgumentBuilder<class_2168> $, class_7157 buildContext) {
        $.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump_recipes").requires(src -> src.method_9259(4))).executes(DumpRecipesCommand::dumpAllRecipes)).then(class_2170.method_9244((String)"type", (ArgumentType)class_7733.method_45603((class_7157)buildContext, (class_5321)class_7924.field_41217)).executes(ctx -> DumpRecipesCommand.dumpRecipes((CommandContext<class_2168>)ctx, class_7733.method_45602((CommandContext)ctx, (String)"type", (class_5321)class_7924.field_41217))))).then(class_2170.method_9247((String)"all").executes(DumpRecipesCommand::dumpAllRecipes)));
    }

    private static int dumpRecipes(CommandContext<class_2168> ctx, class_6880.class_6883<class_3956<?>> type) throws CommandSyntaxException {
        Path dir = Services.PLATFORM.getGameDir().resolve("sparkweave").resolve("recipe_export");
        DumpRecipesCommand.saveRecipes(ctx, type, dir);
        CommandHelper.sendPathResult(ctx, dir.resolve(type.method_40237().method_29177().method_12836()).resolve(type.method_40237().method_29177().method_12832()), () -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_recipes.success", (Object[])new Object[]{type.method_40237().method_29177()}), path -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_recipes.success_path", (Object[])new Object[]{type.method_40237().method_29177(), path}));
        return 1;
    }

    private static int dumpAllRecipes(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Path dir = Services.PLATFORM.getGameDir().resolve("sparkweave").resolve("recipe_export");
        List types = ((class_2168)ctx.getSource()).method_30497().method_30530(class_7924.field_41217).method_40270().toList();
        for (class_6880.class_6883 type : types) {
            DumpRecipesCommand.saveRecipes(ctx, type, dir);
        }
        if (((class_2168)ctx.getSource()).method_9211().method_19466(player.method_7334())) {
            class_5250 path = class_2561.method_43470((String)dir.toString()).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1078, class_124.field_1073}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.sparkweave.open_folder"))).method_10958(new class_2558(class_2558.class_2559.field_11746, dir.toString())));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_recipes.multi_success_path", (Object[])new Object[]{types.size(), path}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.sparkweave.debug.dump_recipes.multi_success", (Object[])new Object[]{types.size()}), true);
        }
        return types.size();
    }

    private static void saveRecipes(CommandContext<class_2168> ctx, class_6880.class_6883<class_3956<?>> holder, Path dir) throws CommandSyntaxException {
        if (!holder.method_40227()) {
            throw TYPE_NOT_FOUND.create((Object)holder.method_40237().method_29177());
        }
        List recipes = ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)holder.comp_349());
        Path outputFile = dir.resolve(holder.method_40237().method_29177().method_12836()).resolve(holder.method_40237().method_29177().method_12832() + ".csv");
        class_2378 serializers = ((class_2168)ctx.getSource()).method_30497().method_30530(class_7924.field_41216);
        try {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            try (CSVWriter writer = CSVWriter.create(Files.newOutputStream(outputFile, new OpenOption[0]), "namespace", "path", "group", "serializer", "special");){
                for (class_8786 recipeHolder : recipes) {
                    writer.addRow(recipeHolder.comp_1932().method_12836(), recipeHolder.comp_1932().method_12832(), recipeHolder.comp_1933().method_8112(), serializers.method_10221((Object)recipeHolder.comp_1933().method_8119()), recipeHolder.comp_1933().method_8118());
                }
            }
        }
        catch (IOException e) {
            throw CommandHelper.IO_EXCEPTION.create((Object)e);
        }
    }
}

