/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class OriginLootCondition
implements class_5341 {
    public static final MapCodec<OriginLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("origin").forGetter(OriginLootCondition::getOrigin), (App)class_2960.field_25139.optionalFieldOf("layer").forGetter(OriginLootCondition::getLayer)).apply((Applicative)instance, OriginLootCondition::new));
    public static final class_5342 TYPE = new class_5342(CODEC);
    private final class_2960 origin;
    private final Optional<class_2960> layer;

    private OriginLootCondition(class_2960 origin, Optional<class_2960> layer) {
        this.origin = origin;
        this.layer = layer;
    }

    public class_5342 method_29325() {
        return TYPE;
    }

    public boolean test(class_47 lootContext) {
        OriginComponent component = ModComponents.ORIGIN.maybeGet(lootContext.method_296(class_181.field_1226)).orElse(null);
        if (component == null) {
            return false;
        }
        for (Map.Entry<OriginLayer, Origin> entry : component.getOrigins().entrySet()) {
            class_2960 layerId = entry.getKey().getId();
            class_2960 originId = entry.getValue().getId();
            if (!this.layer.map(arg_0 -> ((class_2960)layerId).equals(arg_0)).orElse(true).booleanValue() || !originId.equals((Object)this.origin)) continue;
            return true;
        }
        return false;
    }

    public class_2960 getOrigin() {
        return this.origin;
    }

    public Optional<class_2960> getLayer() {
        return this.layer;
    }
}

