/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.client.gui.ImmersivePaintingScreen;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.c2s.ImageRequestPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.util.Cache;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ClientPaintingManager {
    private static final Map<class_2960, Painting> paintings = Collections.synchronizedMap(new HashMap());
    private static final Map<class_2960, Map<Painting.Size, class_2960>> textureMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Boolean> requested = Collections.synchronizedMap(new HashMap());
    private static final ClientCache paintingCache = new ClientCache();
    private static final ExecutorService service = Executors.newFixedThreadPool(2);

    public static Map<class_2960, Painting> getPaintings() {
        return paintings;
    }

    public static Optional<Painting> getPainting(class_2960 identifier) {
        return Optional.ofNullable(paintings.get(identifier));
    }

    private static String textureIdentifier(class_2960 identifier, Painting.Size size) {
        if (size == Painting.Size.FULL) {
            return identifier.method_12832();
        }
        return identifier.method_12832() + "_" + size.name().toLowerCase();
    }

    private static void setImageRequest(class_2960 identifier, boolean thumbnail, boolean delete) {
        String id = ClientPaintingManager.textureIdentifier(identifier, thumbnail ? Painting.Size.THUMBNAIL : Painting.Size.FULL);
        if (requested.containsKey(id) == delete) {
            if (delete) {
                requested.remove(id);
            } else {
                requested.put(id, true);
                NetworkHandler.Client.sendToServer(new ImageRequestPayload(identifier, thumbnail));
            }
        }
    }

    private static class_2960 getOrNSFW(Map<Painting.Size, class_2960> mapping, class_2960 identifier, Painting.Size size) {
        if (Configs.CLIENT.showNSFWPaintings) {
            return mapping.get((Object)size);
        }
        Painting p = paintings.get(identifier);
        if (!p.has(Painting.Flag.NSFW)) {
            return mapping.get((Object)size);
        }
        if (mapping.containsKey((Object)Painting.Size.NSFW)) {
            return mapping.get((Object)Painting.Size.NSFW);
        }
        if (!mapping.containsKey((Object)Painting.Size.THUMBNAIL)) {
            ClientPaintingManager.setImageRequest(identifier, true, false);
            return Painting.DEFAULT_IDENTIFIER;
        }
        Optional image = paintingCache.get(ClientPaintingManager.textureIdentifier(identifier, Painting.Size.THUMBNAIL));
        image.ifPresent(bufferedImage -> ClientPaintingManager.registerImageType(identifier, bufferedImage, Painting.Size.NSFW, Painting.Size.NSFW, false));
        return Painting.DEFAULT_IDENTIFIER;
    }

    public static class_2960 getImageIdentifier(class_2960 identifier, Painting.Size size) {
        if (!paintings.containsKey(identifier)) {
            return Painting.DEFAULT_IDENTIFIER;
        }
        Map<Painting.Size, class_2960> mapping = textureMap.get(identifier);
        if (mapping == null) {
            ClientPaintingManager.setImageRequest(identifier, true, false);
            if (size != Painting.Size.THUMBNAIL) {
                ClientPaintingManager.setImageRequest(identifier, false, false);
            }
            return Painting.DEFAULT_IDENTIFIER;
        }
        if (!mapping.containsKey((Object)size)) {
            boolean isThumbnail = size == Painting.Size.THUMBNAIL;
            ClientPaintingManager.setImageRequest(identifier, isThumbnail, false);
            if (!isThumbnail && mapping.containsKey((Object)Painting.Size.THUMBNAIL)) {
                return ClientPaintingManager.getOrNSFW(mapping, identifier, Painting.Size.THUMBNAIL);
            }
            return Painting.DEFAULT_IDENTIFIER;
        }
        return ClientPaintingManager.getOrNSFW(mapping, identifier, size);
    }

    public static void registerPainting(class_2960 identifier, Painting painting) {
        String fullId = ClientPaintingManager.textureIdentifier(identifier, Painting.Size.FULL);
        String thumbId = ClientPaintingManager.textureIdentifier(identifier, Painting.Size.THUMBNAIL);
        requested.put(fullId, true);
        requested.put(thumbId, true);
        paintings.put(identifier, painting);
        paintingCache.get(thumbId).ifPresentOrElse(bufferedImage -> ClientPaintingManager.registerThumbnail(identifier, bufferedImage, true), () -> requested.remove(thumbId));
        paintingCache.get(fullId).ifPresentOrElse(bufferedImage -> ClientPaintingManager.registerImage(identifier, bufferedImage, true), () -> requested.remove(fullId));
    }

    public static void deregisterPainting(class_2960 identifier) {
        if (!paintings.containsKey(identifier)) {
            return;
        }
        paintings.remove(identifier);
        Map<Painting.Size, class_2960> map = textureMap.remove(identifier);
        if (map != null) {
            class_1060 manager = class_310.method_1551().method_1531();
            map.forEach((size, id) -> {
                paintingCache.delete(ClientPaintingManager.textureIdentifier(identifier, size));
                manager.method_4615(id);
            });
        }
    }

    private static void registerImageType(class_2960 identifier, BufferedImage fullImage, Painting.Size size, Painting.Size realSize, boolean alreadyCached) {
        textureMap.putIfAbsent(identifier, new HashMap());
        Map<Painting.Size, class_2960> mapping = textureMap.get(identifier);
        if (mapping.containsKey((Object)size) && size != realSize) {
            mapping.put(realSize, mapping.get((Object)size));
            return;
        }
        service.submit(() -> {
            class_437 patt0$temp;
            BufferedImage target;
            String path = ClientPaintingManager.textureIdentifier(identifier, realSize);
            Optional img = paintingCache.get(path);
            if (img.isPresent()) {
                target = (BufferedImage)img.get();
            } else {
                target = realSize == Painting.Size.THUMBNAIL ? fullImage : ImageManipulations.resizeImage(fullImage, size);
                if (!alreadyCached) {
                    paintingCache.set(path, target);
                }
            }
            class_2960 id = class_310.method_1551().method_1531().method_4617("immersive_paintings/" + path, new class_1043(ImageManipulations.bufferedToNative(target)));
            mapping.put(realSize, id);
            if (size == Painting.Size.THUMBNAIL && (patt0$temp = class_310.method_1551().field_1755) instanceof ImmersivePaintingScreen) {
                ImmersivePaintingScreen screen = (ImmersivePaintingScreen)patt0$temp;
                screen.updateWidget(identifier);
            }
        });
    }

    public static void registerThumbnail(class_2960 identifier, BufferedImage image, boolean alreadyCached) {
        ClientPaintingManager.registerImageType(identifier, image, Painting.Size.THUMBNAIL, Painting.Size.THUMBNAIL, alreadyCached);
        ClientPaintingManager.setImageRequest(identifier, true, true);
    }

    public static void registerImage(class_2960 identifier, BufferedImage image, boolean alreadyCached) {
        if (!paintings.containsKey(identifier) && !alreadyCached) {
            Main.LOGGER.error("no existing painting record for identifier {}", (Object)identifier);
            return;
        }
        if (textureMap.containsKey(identifier) && textureMap.get(identifier).containsKey((Object)Painting.Size.FULL)) {
            return;
        }
        Painting painting = paintings.get(identifier);
        int res = Math.max(painting.width(), painting.height()) * painting.resolution();
        ClientPaintingManager.registerImageType(identifier, image, Painting.Size.FULL, Painting.Size.FULL, alreadyCached);
        Painting.Size halfSize = res / 2 < Configs.CLIENT.lodResolutionMinimum ? Painting.Size.FULL : Painting.Size.HALF;
        ClientPaintingManager.registerImageType(identifier, image, halfSize, Painting.Size.HALF, alreadyCached);
        Painting.Size quarterSize = res / 4 < Configs.CLIENT.lodResolutionMinimum ? halfSize : Painting.Size.QUARTER;
        ClientPaintingManager.registerImageType(identifier, image, quarterSize, Painting.Size.QUARTER, alreadyCached);
        Painting.Size eighthSize = res / 8 < Configs.CLIENT.lodResolutionMinimum ? quarterSize : Painting.Size.EIGHTH;
        ClientPaintingManager.registerImageType(identifier, image, eighthSize, Painting.Size.EIGHTH, alreadyCached);
        ClientPaintingManager.setImageRequest(identifier, false, true);
    }

    private static class ClientCache
    extends Cache<String, BufferedImage> {
        private ClientCache() {
        }

        @Override
        public String getCachePath(String key) {
            return key + ".png";
        }

        @Override
        public BufferedImage decode(byte[] bytes) {
            try {
                return ImageManipulations.decode(bytes);
            }
            catch (IOException e) {
                Main.LOGGER.error("could not read image from client cache", (Throwable)e);
                return null;
            }
        }

        @Override
        public byte[] encode(BufferedImage image) {
            try {
                return ImageManipulations.encode(image);
            }
            catch (IOException e) {
                Main.LOGGER.error("could not write image to client cache", (Throwable)e);
                return null;
            }
        }
    }
}

