/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.util.ImageManipulations;

public class SegmentManager {
    private final Map<String, ByteArrayOutputStream> buffer = new HashMap<String, ByteArrayOutputStream>();

    public Optional<BufferedImage> handleSegmentedPayload(String key, byte[] data, int segment, int totalSegments) {
        ByteArrayOutputStream byteBuffer = this.buffer.computeIfAbsent(key, k -> new ByteArrayOutputStream());
        try {
            byteBuffer.write(data);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (segment + 1 == totalSegments) {
            this.buffer.remove(key);
            try {
                return Optional.of(ImageManipulations.decode(byteBuffer.toByteArray()));
            }
            catch (IOException e) {
                Main.LOGGER.error("could not combne segmented payloads for {}", (Object)key, (Object)e);
            }
        }
        return Optional.empty();
    }
}

