/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client;

import com.google.auto.service.AutoService;
import com.google.common.base.MoreObjects;
import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.DiscordsWingsModel;
import dev.cammiescorner.icarus.client.models.FeatheredWingsModel;
import dev.cammiescorner.icarus.client.models.FlandresWingsModel;
import dev.cammiescorner.icarus.client.models.LeatherWingsModel;
import dev.cammiescorner.icarus.client.models.LightWingsModel;
import dev.cammiescorner.icarus.client.models.ZanzasWingsModel;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.util.IcarusHelper;
import dev.upcraft.sparkweave.api.client.event.RegisterLayerDefinitionsEvent;
import dev.upcraft.sparkweave.api.entrypoint.ClientEntryPoint;
import dev.upcraft.sparkweave.api.event.EntityTickEvents;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;

@AutoService(value={ClientEntryPoint.class})
public class IcarusClient
implements ClientEntryPoint {
    private static final List<Predicate<class_1309>> renderPredicates = new ArrayList<Predicate<class_1309>>();

    public void onInitializeClient(ModContainer mod) {
        EntityTickEvents.startTick(class_742.class).register(IcarusClient::onPlayerTick);
        RegisterLayerDefinitionsEvent.EVENT.register(event -> {
            event.registerModelLayers(IcarusModels.FEATHERED, FeatheredWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.LEATHER, LeatherWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.LIGHT, LightWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.FLANDRE, FlandresWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.DISCORD, DiscordsWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.ZANZA, ZanzasWingsModel::getLayerDefinition);
        });
    }

    public static boolean onPlayerTick(class_742 player, class_1937 level) {
        if (player.method_6128() && IcarusHelper.hasWings((class_1309)player) && player.field_6250 > 0.0f) {
            class_1799 wings;
            IcarusPlayerValues cfg = IcarusHelper.getConfigValues((class_1309)player);
            class_243 rotation = player.method_5720();
            class_243 velocity = player.method_18798();
            float upwardsAngleOfAttack = class_3532.method_15356((float)player.method_36455(), (float)-90.0f);
            float speed = cfg.wingsSpeed() * (upwardsAngleOfAttack <= 15.0f ? 2.75f : 1.0f);
            if (cfg.armorSlows() && (wings = IcarusHelper.getEquippedWings.apply((class_1309)player)) != null && !wings.method_7960() && !wings.method_31573(IcarusItemTags.BYPASSES_ARMOR_SLOWDOWN)) {
                speed /= Math.max(1.0f, (float)player.method_6096() / 30.0f * cfg.maxSlowedMultiplier());
            }
            player.method_18799(velocity.method_1031(rotation.field_1352 * (double)speed + (rotation.field_1352 * 1.5 - velocity.field_1352) * (double)speed, rotation.field_1351 * (double)speed + (rotation.field_1351 * 1.5 - velocity.field_1351) * (double)speed, rotation.field_1350 * (double)speed + (rotation.field_1350 * 1.5 - velocity.field_1350) * (double)speed));
        }
        return false;
    }

    @ApiStatus.Internal
    public static class_1799 getWingsForRendering(class_1309 entity) {
        return (class_1799)MoreObjects.firstNonNull((Object)IcarusHelper.getEquippedWings.apply(entity), (Object)class_1799.field_8037);
    }

    @ApiStatus.Internal
    public static void addRenderPredicate(Predicate<class_1309> predicate) {
        renderPredicates.add(predicate);
    }

    public static boolean shouldRenderWings(class_1309 entity) {
        if (!renderPredicates.isEmpty()) {
            for (Predicate<class_1309> predicate : renderPredicates) {
                if (predicate.test(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public static void sendActionbarMessage(class_1657 player, class_2561 message) {
        if (player instanceof class_746) {
            class_746 localPlayer = (class_746)player;
            localPlayer.method_7353(message, true);
        }
    }
}

